/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.magicall.support.coll.CollKit;

@FunctionalInterface
public interface Identified<I> {
    public I id();

    public static <I, G extends Identified<I>> List<I> toIds(Iterable<G> source) {
        return CollKit.stream(source).map(Identified::id).collect(Collectors.toList());
    }

    public static <I, G extends Identified<I>> Map<I, G> map(Iterable<G> source) {
        return CollKit.stream(source).collect(Collectors.toMap(Identified::id, Function.identity()));
    }

    public static String randomId() {
        return UUID.randomUUID().toString();
    }
}

