/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.magicall.support.NamedDto;

@FunctionalInterface
public interface Named {
    public String name();

    default public String fullName() {
        return this.name();
    }

    default public String shortName() {
        return this.name();
    }

    public static Named of(String name) {
        return new SimpleNamed(name);
    }

    public static List<String> toNames(Collection<? extends Named> source) {
        return source.stream().map(Named::name).collect(Collectors.toList());
    }

    public static <T extends Named> Map<String, T> map(Stream<T> source) {
        return source.collect(Collectors.toMap(Named::name, Function.identity()));
    }

    public static <T extends Named> Predicate<T> predicate(String name) {
        return named -> Objects.equals(named.name(), name);
    }

    public static class SimpleNamed
    implements Named {
        private final NamedDto raw;

        public SimpleNamed(String name) {
            this(new NamedDto(name));
        }

        public SimpleNamed(NamedDto raw) {
            this.raw = raw;
        }

        @Override
        public String name() {
            return this.raw.name();
        }

        public String toString() {
            return this.raw.toString();
        }

        public int hashCode() {
            return this.raw.hashCode();
        }

        public boolean equals(Object o) {
            return this.raw.equals(o);
        }
    }
}

