/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support;

import java.io.Serializable;
import java.util.Objects;
import me.magicall.support.lang.java.StrKit;

public interface Thing {
    public static final Thing EMPTY = Thing.of("", "");

    public String type();

    public String idInType();

    public static Thing of(String type, String idInType) {
        return new SimpleThing(type, idInType);
    }

    public static Thing ofType(String type) {
        return new SimpleThing(type, "");
    }

    public static Thing parseThing(String s) {
        int index = s.indexOf(35);
        if (index < 0) {
            return null;
        }
        String idInType = s.substring(index + 1);
        return Thing.of(s.substring(0, index), "*".equals(idInType) ? "" : idInType);
    }

    public static String toString(Thing thing) {
        return StrKit.format("{0}#{1}", thing.type(), thing.idInType());
    }

    public static int hash(Thing thing) {
        return Objects.hash(thing.type(), thing.idInType());
    }

    public static boolean equals(Thing thing, Object o) {
        if (thing == o) {
            return true;
        }
        if (o instanceof Thing) {
            Thing other = (Thing)o;
            return Objects.equals(thing.type(), other.type()) && Objects.equals(thing.idInType(), other.idInType());
        }
        return false;
    }

    public static class SimpleThing
    implements Thing {
        private final ThingDto dto;

        public SimpleThing() {
            this.dto = new ThingDto();
        }

        public SimpleThing(String type, Object idInType) {
            this.dto = new ThingDto(type, idInType);
        }

        @Override
        public String type() {
            return this.dto.type;
        }

        @Override
        public String idInType() {
            return this.dto.idInType;
        }

        public String toString() {
            return Thing.toString(this);
        }

        public boolean equals(Object o) {
            return Thing.equals(this, o);
        }

        public int hashCode() {
            return Thing.hash(this);
        }
    }

    public static class ThingDto
    implements Thing,
    Serializable {
        private static final long serialVersionUID = -533161370753523575L;
        public String type;
        public String idInType;

        public ThingDto() {
        }

        public ThingDto(String type, Object idInType) {
            this.type = type;
            this.idInType = String.valueOf(idInType);
        }

        @Override
        public String type() {
            return this.type;
        }

        @Override
        public String idInType() {
            return this.idInType;
        }

        public String toString() {
            return Thing.toString(this);
        }

        public boolean equals(Object o) {
            return Thing.equals(this, o);
        }

        public int hashCode() {
            return Thing.hash(this);
        }
    }
}

