/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.coll;

import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import me.magicall.support.coll.EmptyNavigableSubSet;
import me.magicall.support.coll.NavigableSetSupport;
import me.magicall.support.coll.NavigableSubSet;

public class BitSwitchers
extends AbstractSet<Integer>
implements NavigableSetSupport<Integer> {
    private final BitSet negative;
    private final BitSet positive;

    public BitSwitchers() {
        this(new BitSet(), new BitSet());
    }

    public BitSwitchers(Collection<Integer> c) {
        this();
        this.addAll0(c);
    }

    private BitSwitchers(BitSet negative, BitSet positive) {
        this.negative = negative;
        this.positive = positive;
    }

    public boolean contains(Integer integer) {
        return integer < 0 ? this.negative.get(BitSwitchers.negativeValToIndex(integer)) : this.positive.get(integer);
    }

    private static int negativeValToIndex(Integer negative) {
        return negative - Integer.MIN_VALUE;
    }

    private static int indexToNegativeVal(int index) {
        return index + Integer.MIN_VALUE;
    }

    private static boolean set(BitSet bitSet, Integer bitIndex) {
        if (bitSet.get(bitIndex)) {
            return false;
        }
        bitSet.set(bitIndex);
        return true;
    }

    private static boolean clear(BitSet bitSet, Integer bitIndex) {
        if (bitSet.get(bitIndex)) {
            bitSet.clear(bitIndex);
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new BitSwitchersIterator(this);
    }

    @Override
    public int size() {
        long size = this.longSize();
        return size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size;
    }

    public long longSize() {
        long cardinality1 = this.negative.cardinality();
        long cardinality2 = this.positive.cardinality();
        return cardinality1 + cardinality2;
    }

    @Override
    public boolean add(Integer integer) {
        return integer < 0 ? BitSwitchers.set(this.negative, BitSwitchers.negativeValToIndex(integer)) : BitSwitchers.set(this.positive, integer);
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Integer)) {
            return false;
        }
        Integer integer = (Integer)o;
        return integer < 0 ? BitSwitchers.clear(this.negative, BitSwitchers.negativeValToIndex(integer)) : BitSwitchers.clear(this.positive, integer);
    }

    @Override
    public void clear() {
        this.negative.clear();
        this.positive.clear();
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof Integer && this.contains((Integer)o);
    }

    @Override
    public Stream<Integer> stream() {
        return IntStream.concat(this.negative.stream().filter(this.negative::get).map(BitSwitchers::indexToNegativeVal), this.positive.stream().filter(this.positive::get)).boxed();
    }

    @Override
    public boolean addAll(Collection<? extends Integer> c) {
        return this.addAll0(c);
    }

    private boolean addAll0(Collection<Integer> c) {
        if (c instanceof BitSwitchers) {
            BitSwitchers other = (BitSwitchers)c;
            this.negative.or(other.negative);
            this.positive.or(other.positive);
        }
        return super.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c instanceof BitSwitchers) {
            BitSwitchers other = (BitSwitchers)c;
            this.negative.andNot(other.negative);
            this.positive.andNot(other.positive);
        }
        return super.removeAll(c);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        if (!(c instanceof BitSwitchers)) return super.containsAll(c);
        BitSwitchers other = (BitSwitchers)c;
        if (!other.negative.stream().allMatch(this.negative::get)) return false;
        if (!other.positive.stream().allMatch(this.positive::get)) return false;
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c instanceof BitSwitchers) {
            BitSwitchers other = (BitSwitchers)c;
            return BitSwitchers.retain(this.negative, other.negative) && BitSwitchers.retain(this.positive, other.positive);
        }
        return super.retainAll(c);
    }

    private static boolean retain(BitSet bitSet1, BitSet bitSet2) {
        boolean intersects = bitSet1.intersects(bitSet2);
        if (intersects) {
            bitSet1.and(bitSet2);
        } else {
            bitSet1.clear();
        }
        return intersects;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BitSwitchers) {
            BitSwitchers other = (BitSwitchers)o;
            return this.negative.equals(other.negative) && this.positive.equals(other.positive);
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.negative.hashCode();
        result = 31 * result + this.positive.hashCode();
        return result;
    }

    @Override
    public Comparator<? super Integer> comparator() {
        return null;
    }

    @Override
    public Integer firstOrNull() {
        if (this.negative.isEmpty()) {
            if (this.positive.isEmpty()) {
                return null;
            }
            return this.positive.nextSetBit(0);
        }
        return BitSwitchers.indexToNegativeVal(this.negative.nextSetBit(0));
    }

    @Override
    public Integer lastOrNull() {
        if (this.positive.isEmpty()) {
            if (this.negative.isEmpty()) {
                return null;
            }
            return BitSwitchers.indexToNegativeVal(this.negative.length() - 1);
        }
        return this.positive.length() - 1;
    }

    @Override
    public Integer lower(Integer target) {
        return target == Integer.MIN_VALUE ? null : this.floor(target - 1);
    }

    @Override
    public Integer floor(Integer target) {
        int i;
        if (target >= 0 && (i = this.positive.previousSetBit(target)) >= 0) {
            return i;
        }
        int from = target < 0 ? BitSwitchers.negativeValToIndex(target) : Integer.MAX_VALUE;
        int i2 = this.negative.previousSetBit(from);
        return i2 < 0 ? null : Integer.valueOf(BitSwitchers.indexToNegativeVal(i2));
    }

    @Override
    public Integer higher(Integer target) {
        return Objects.equals(target, Integer.MAX_VALUE) ? null : this.ceiling(target + 1);
    }

    @Override
    public Integer ceiling(Integer target) {
        int i;
        if (target < 0 && (i = this.negative.nextSetBit(BitSwitchers.negativeValToIndex(target))) >= 0) {
            return BitSwitchers.indexToNegativeVal(i);
        }
        i = this.positive.nextSetBit(Math.max(0, target));
        return i < 0 ? null : Integer.valueOf(i);
    }

    @Override
    public NavigableSet<Integer> subSet(Integer fromElement, boolean fromInclusive, Integer toElement, boolean toInclusive) {
        if (fromInclusive && fromElement == Integer.MAX_VALUE || toInclusive && toElement == Integer.MIN_VALUE) {
            return new EmptyNavigableSubSet<Integer>(this.comparator());
        }
        if (!(!Objects.equals(fromElement, toElement) || fromInclusive && toInclusive)) {
            return new EmptyNavigableSubSet<Integer>(this.comparator());
        }
        return new NavigableSubSet<Integer>(this, fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    public NavigableSet<Integer> headSet(Integer toElement, boolean inclusive) {
        return this.subSet(Integer.MIN_VALUE, true, toElement, inclusive);
    }

    @Override
    public NavigableSet<Integer> tailSet(Integer fromElement, boolean inclusive) {
        return this.subSet(fromElement, inclusive, Integer.MAX_VALUE, true);
    }

    private static class BitSwitchersIterator
    implements Iterator<Integer> {
        final NavigableSet<Integer> raw;
        Integer cur;
        boolean started;

        private BitSwitchersIterator(NavigableSet<Integer> raw) {
            this.raw = raw;
        }

        @Override
        public boolean hasNext() {
            return this.nextOrNull() != null;
        }

        @Override
        public Integer next() {
            Integer i = this.nextOrNull();
            if (i == null) {
                throw new NoSuchElementException();
            }
            this.cur = i;
            this.started = true;
            return i;
        }

        private Integer nextOrNull() {
            int i;
            if (this.cur == null) {
                if (this.started) {
                    return null;
                }
                i = Integer.MIN_VALUE;
            } else {
                if (this.cur == Integer.MAX_VALUE) {
                    return null;
                }
                i = this.cur + 1;
            }
            return this.raw.ceiling(i);
        }

        @Override
        public void remove() {
            if (!this.started || this.cur == null) {
                throw new IllegalStateException();
            }
            this.raw.remove(this.cur);
        }
    }
}

