/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.coll;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import me.magicall.support.coll.AbsCollKit;
import me.magicall.support.coll.EmptyColl;
import me.magicall.support.lang.java.Kits;
import me.magicall.support.lang.java.ObjKit;

public final class CollKit
extends AbsCollKit<Collection<?>>
implements Serializable {
    private static final long serialVersionUID = -8028661636852704700L;
    private static final List<Class<?>> SUPPORTED_CLASSES = Collections.singletonList(Collection.class);
    private static final Random RANDOM = new SecureRandom();
    public static final CollKit INSTANCE = new CollKit();

    @Override
    public Stream<Class<?>> supportedClasses() {
        return SUPPORTED_CLASSES.stream();
    }

    @Override
    public Stream<String> supportedTypeNames() {
        return Stream.concat(super.supportedTypeNames(), Stream.of("coll"));
    }

    @Override
    public Collection<?> parse(String source) {
        return null;
    }

    @Override
    public <E, E1> Collection<E> emptyVal() {
        return EmptyColl.INSTANCE;
    }

    @Override
    public <T> Collection<T> cast(Collection<?> source) {
        return source;
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public static <T> Stream<T> stream(Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
    }

    public static <T> Stream<T> stream(Iterable<T> source) {
        return Streams.stream(source);
    }

    @SafeVarargs
    public static <T> Stream<T> stream(T ... source) {
        return Stream.of(source);
    }

    public static <E> E first(Collection<E> source, Predicate<? super E> predicate) {
        return source.stream().filter(predicate).findFirst().orElse(null);
    }

    public static <E> boolean deepContains(Collection<E> source, E target) {
        return source.stream().anyMatch(e -> ObjKit.deepEquals(e, target));
    }

    public static <E> int locateFirst(Collection<E> source, Predicate<? super E> predicate) {
        int count = (int)source.stream().takeWhile(predicate.negate()).count();
        return count == source.size() ? -1 : count;
    }

    public static int locateFirst(Object target, Collection<?> source) {
        return CollKit.locateFirst(source, Predicate.isEqual(target));
    }

    public static <T> T randomOne(Collection<T> source) {
        if (source instanceof List) {
            return (T)Kits.LIST.random((List)source);
        }
        if (INSTANCE.isEmpty(source)) {
            return null;
        }
        int index = RANDOM.nextInt(source.size());
        Iterator it = source.iterator();
        IntStream.range(0, index).forEach(i -> it.next());
        return it.next();
    }

    public static <T> Collection<T> randomSome(Collection<T> source, int size) {
        ArrayList list = Lists.newArrayList(source);
        if (source.size() <= size) {
            return list;
        }
        Collections.shuffle(list);
        return list.subList(0, size);
    }

    public static boolean removeEachOther(Collection<?> c1, Collection<?> c2) {
        return CollKit.removeEachOther(c1, c2, Objects::equals);
    }

    public static boolean removeEachOther(Collection<?> c1, Collection<?> c2, BiPredicate<Object, Object> equaler) {
        return c1.removeIf(e -> c2.removeIf(e2 -> equaler.test(e, e2)));
    }

    public static <T> Stream<T> concat(Stream<? extends T> ... streams) {
        return Stream.of(streams).reduce(Stream::concat).orElse(Stream.empty());
    }

    public static <A, B> void biIterate(Iterator<A> items1, Iterator<B> items2, BiConsumer<A, B> consumer) {
        while (items1.hasNext()) {
            consumer.accept(items1.next(), items2.hasNext() ? (Object)items2.next() : null);
        }
        while (items2.hasNext()) {
            consumer.accept(null, items2.next());
        }
    }

    public static <A, B, C> Stream<C> biIterate(Iterator<A> items1, Iterator<B> items2, BiFunction<A, B, C> function) {
        ArrayList rt = Lists.newArrayList();
        CollKit.biIterate(items1, items2, (A a, B b) -> rt.add(function.apply(a, b)));
        return rt.stream();
    }

    public static <A, B> void biIterate(Iterable<A> items1, Iterable<B> items2, BiConsumer<A, B> consumer) {
        CollKit.biIterate(items1.iterator(), items2.iterator(), consumer);
    }

    public static <A, B, C> Stream<C> biIterate(Iterable<A> items1, Iterable<B> items2, BiFunction<A, B, C> function) {
        return CollKit.biIterate(items1.iterator(), items2.iterator(), function);
    }
}

