/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.coll;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.magicall.support.coll.Tree;
import me.magicall.support.coll.TreeNodeTemplate;
import me.magicall.support.coll.TreeNodeWrapper;

public class CommonTreeNode<E>
extends TreeNodeTemplate<E> {
    protected E element;
    protected Tree.TreeNode<E> parent;
    protected Collection<Tree.TreeNode<E>> children;

    public CommonTreeNode() {
        this(Lists.newArrayList());
    }

    protected CommonTreeNode(Collection<Tree.TreeNode<E>> children) {
        this(null, (Collection<Tree.TreeNode<Object>>)children);
    }

    public CommonTreeNode(E element) {
        this(element, Lists.newArrayList());
    }

    protected CommonTreeNode(E element, Collection<Tree.TreeNode<E>> children) {
        this(element, null, children);
    }

    protected CommonTreeNode(Tree.TreeNode<E> parent) {
        this(parent, (Collection<Tree.TreeNode<E>>)Lists.newArrayList());
    }

    protected CommonTreeNode(Tree.TreeNode<E> parent, Collection<Tree.TreeNode<E>> children) {
        this(null, parent, children);
    }

    protected CommonTreeNode(E element, Tree.TreeNode<E> parent) {
        this(element, parent, Lists.newArrayList());
    }

    protected CommonTreeNode(E element, Tree.TreeNode<E> parent, Collection<Tree.TreeNode<E>> children) {
        this.parent = parent;
        this.element = element;
        this.children = Lists.newArrayList(children);
    }

    @Override
    public Tree.TreeNode<E> addSubTree(Tree<E> tree) {
        final CommonTreeNode n = this;
        this.children.add(new TreeNodeWrapper<E>(tree.getRoot()){

            @Override
            public Tree.TreeNode<E> parent() {
                return n;
            }
        });
        return this;
    }

    @Override
    public Stream<? extends Tree.TreeNode<E>> children() {
        return this.children.stream();
    }

    @Override
    public Tree.TreeNode<E> child(E child) {
        CommonTreeNode<E> wrap = new CommonTreeNode<E>(child, this);
        this.children.add(wrap);
        return wrap;
    }

    @Override
    public boolean removeChild(Predicate<? super Tree.TreeNode<?>> predicate) {
        return this.children.removeIf(predicate);
    }

    @Override
    public E getElement() {
        return this.element;
    }

    @Override
    public E setElement(E newElement) {
        E rt = this.element;
        this.element = newElement;
        return rt;
    }

    @Override
    public Tree.TreeNode<E> parent() {
        return this.parent;
    }
}

