/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.coll;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.NoSuchElementException;

public class DescendingSet<E>
extends AbstractSet<E>
implements NavigableSet<E> {
    protected final NavigableSet<E> raw;

    public DescendingSet(NavigableSet<E> raw) {
        this.raw = raw;
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return this.raw;
    }

    @Override
    public Iterator<E> iterator() {
        return new DescendingIterator<E>(this.raw);
    }

    @Override
    public int size() {
        return this.descendingSet().size();
    }

    @Override
    public boolean add(E e) {
        return this.descendingSet().add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.descendingSet().remove(o);
    }

    @Override
    public E lower(E e) {
        return this.descendingSet().higher(e);
    }

    @Override
    public E floor(E e) {
        return this.descendingSet().ceiling(e);
    }

    @Override
    public E ceiling(E e) {
        return this.descendingSet().floor(e);
    }

    @Override
    public E higher(E e) {
        return this.descendingSet().lower(e);
    }

    @Override
    public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return this.descendingSet().subSet(toElement, toInclusive, fromElement, fromInclusive);
    }

    @Override
    public NavigableSet<E> subSet(E fromElement, E toElement) {
        return this.descendingSet().subSet(toElement, false, fromElement, true);
    }

    @Override
    public NavigableSet<E> headSet(E toElement) {
        return this.descendingSet().tailSet(toElement, false);
    }

    @Override
    public NavigableSet<E> tailSet(E fromElement) {
        return this.descendingSet().headSet(fromElement, false);
    }

    @Override
    public NavigableSet<E> headSet(E toElement, boolean inclusive) {
        return this.descendingSet().tailSet(toElement, inclusive);
    }

    @Override
    public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        return this.descendingSet().headSet(fromElement, inclusive);
    }

    @Override
    public Comparator<? super E> comparator() {
        Comparator comparator = this.descendingSet().comparator();
        return comparator == null ? null : comparator.reversed();
    }

    @Override
    public boolean contains(Object o) {
        return this.descendingSet().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.descendingSet().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.descendingSet().addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.descendingSet().retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.descendingSet().removeAll(c);
    }

    @Override
    public void clear() {
        this.descendingSet().clear();
    }

    @Override
    public boolean isEmpty() {
        return this.descendingSet().isEmpty();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.descendingSet().iterator();
    }

    @Override
    public E first() {
        return this.descendingSet().last();
    }

    @Override
    public E last() {
        return this.descendingSet().first();
    }

    @Override
    public E pollFirst() {
        return this.descendingSet().pollLast();
    }

    @Override
    public E pollLast() {
        return this.descendingSet().pollFirst();
    }

    @Override
    public boolean equals(Object o) {
        return this.descendingSet().equals(o);
    }

    @Override
    public int hashCode() {
        return this.descendingSet().hashCode();
    }

    static class DescendingIterator<E>
    implements Iterator<E> {
        protected final NavigableSet<E> raw;
        protected E cur;

        DescendingIterator(NavigableSet<E> raw) {
            this.raw = raw;
        }

        @Override
        public boolean hasNext() {
            if (this.cur == null) {
                return !this.raw.isEmpty();
            }
            return this.raw.lower(this.cur) != null;
        }

        @Override
        public E next() {
            if (this.cur == null) {
                this.cur = this.raw.last();
            } else {
                this.cur = this.raw.lower(this.cur);
                if (this.cur == null) {
                    throw new NoSuchElementException();
                }
            }
            return this.cur;
        }

        @Override
        public void remove() {
            this.raw.remove(this.cur);
        }
    }
}

