/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.coll;

import java.util.function.BiFunction;
import java.util.function.Function;

@FunctionalInterface
public interface ElementTransformer<F, T>
extends BiFunction<Integer, F, T> {
    public static final ElementTransformer<Object, Integer> TO_INDEX = (index, element) -> index;
    public static final ElementTransformer<Object, Object> NO_TRANS = (index, from) -> from;
    public static final ElementTransformer<Object, Class<?>> TO_CLASS = (index, element) -> element.getClass();
    public static final ElementTransformer<Object, Integer> TO_HASH_CODE = (index, element) -> element.hashCode();
    public static final ElementTransformer<Object, String> TO_STRING = (index, element) -> element.toString();
    public static final ElementTransformer<String, String> TO_LOWER_CASE = (index, element) -> element.toLowerCase();
    public static final ElementTransformer<Enum<?>, String> ENUM_TO_NAME = (index, element) -> element.name();

    public static <F, T> ElementTransformer<F, T> noTrans() {
        return NO_TRANS;
    }

    public T transform(int var1, F var2);

    @Override
    default public T apply(Integer integer, F f) {
        return this.transform(integer, f);
    }

    default public Function<F, T> ignoreIndex() {
        return f -> this.transform(-1, f);
    }
}

