/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.coll;

import java.util.function.Predicate;
import java.util.stream.Stream;

@FunctionalInterface
public interface Linked<T extends Linked<T>> {
    public T preNode();

    default public boolean isRoot() {
        return this.preNode() == null;
    }

    default public Stream<T> streamToRoot() {
        return Stream.iterate(this, t -> !t.isRoot(), Linked::preNode);
    }

    default public T findInPreNodes(Predicate<T> predicate) {
        Linked<T> t = this;
        while (true) {
            if (predicate.test(t)) {
                return (T)t;
            }
            if (t == null) break;
            t = t.preNode();
        }
        return null;
    }

    default public T findRoot() {
        return (T)this.findInPreNodes(Linked::isRoot);
    }

    default public T findInPreNodes(Class<? extends T> clazz) {
        return (T)this.findInPreNodes(clazz::isInstance);
    }
}

