/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.coll;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.magicall.support.Unmodifiable;
import me.magicall.support.coll.AbsCollKit;
import me.magicall.support.coll.ElementTransformer;
import me.magicall.support.coll.EmptyColl;
import me.magicall.support.coll.ReverseList;

public final class ListKit
extends AbsCollKit<List<?>>
implements Serializable {
    private static final long serialVersionUID = 7338971757402227665L;
    private static final List<Class<?>> SUPPORTED_CLASSES = Collections.singletonList(List.class);
    private static final Class<?> JDK_COLLECTIONS_UNMODIFIABLE_LIST_CLASS = Collections.unmodifiableList(Collections.emptyList()).getClass();
    public static final ListKit INSTANCE = new ListKit();
    public static final Random RANDOM = new SecureRandom();

    @Override
    public Stream<Class<?>> supportedClasses() {
        return SUPPORTED_CLASSES.stream();
    }

    @Override
    public List<?> parse(String source) {
        return null;
    }

    @Override
    public <E, E1> List<E> emptyVal() {
        return EmptyColl.INSTANCE;
    }

    @Override
    public <T> List<T> cast(List<?> source) {
        return source;
    }

    public static List<Long> seq(long from, int size) {
        return Stream.iterate(from, i -> i + 1L).limit(size).collect(Collectors.toList());
    }

    public static List<Long> seq(long from, long step, int size) {
        return step == 0L ? Collections.nCopies(size, from) : Stream.iterate(from, aLong -> aLong + step).limit(size).collect(Collectors.toList());
    }

    public static List<Integer> seq(int from, int size) {
        return ListKit.seq(from, 1, size);
    }

    public static List<Integer> seq(int from, int step, int size) {
        return step == 0 ? Collections.nCopies(size, from) : Stream.iterate(from, aLong -> aLong + step).limit(size).collect(Collectors.toList());
    }

    public static List<Integer> positiveSeq(int size) {
        return ListKit.seq(1, 1, size);
    }

    public static List<Integer> natureSeq(int size) {
        return ListKit.seq(0, 1, size);
    }

    public <E> E last(List<E> source) {
        return this.isEmpty(source) ? null : (E)source.get(source.size() - 1);
    }

    public <E> E random(List<E> list) {
        if (this.isEmpty(list)) {
            return null;
        }
        int size = list.size();
        return list.get(size == 1 ? 0 : RANDOM.nextInt(size));
    }

    @Deprecated
    public <F, T> List<T> transform(List<? extends F> source, ElementTransformer<? super F, ? extends T> transformer) {
        ArrayList rt = Lists.newArrayList();
        int index = 0;
        for (F element : source) {
            rt.add(transformer.transform(index, element));
            ++index;
        }
        return rt;
    }

    public <T> List<T> reverse(List<T> source) {
        return source instanceof ReverseList ? ((ReverseList)source).unwrap() : new ReverseList<T>(source);
    }

    public <T> List<T> unmodifiable(List<T> source) {
        if (source instanceof Unmodifiable) {
            return source;
        }
        if (source == Collections.emptyList()) {
            return source;
        }
        if (source.getClass() == JDK_COLLECTIONS_UNMODIFIABLE_LIST_CLASS) {
            return source;
        }
        return Collections.unmodifiableList(source);
    }

    public <T> List<T> head(List<T> source, int to) {
        return this.subList(source, 0, to);
    }

    public <T> List<T> tail(List<T> source, int from) {
        return this.subList(source, from, Integer.MAX_VALUE);
    }

    public <T> List<T> subList(List<T> source, int from, int to) {
        int toIndex;
        int fromIndex;
        if (this.isEmpty(source)) {
            return this.emptyVal();
        }
        if (from == to) {
            return this.emptyVal();
        }
        if (from < to) {
            fromIndex = from;
            toIndex = to;
        } else {
            fromIndex = to;
            toIndex = from;
        }
        int size = source.size();
        if (fromIndex < 0) {
            if (toIndex > size) {
                return source;
            }
            if (toIndex < 0) {
                return this.emptyVal();
            }
            fromIndex = 0;
        } else {
            if (fromIndex > size) {
                return this.emptyVal();
            }
            if (toIndex > size) {
                toIndex = size;
            }
        }
        return source.subList(fromIndex, toIndex);
    }

    public <E> List<E> randomSection(List<E> source, int size) {
        if (this.isEmpty(source)) {
            return this.emptyVal();
        }
        if (source.size() <= size) {
            return source;
        }
        int maxFromIndex = RANDOM.nextInt(source.size() - size);
        return this.subList(source, maxFromIndex, maxFromIndex + size);
    }

    public <E> List<E> randomSome(List<E> source, int size) {
        if (this.isEmpty(source)) {
            return this.emptyVal();
        }
        int sourceSize = source.size();
        if (sourceSize <= size) {
            return source;
        }
        ArrayList<E> rt = new ArrayList<E>(size);
        int remainSourceSize = sourceSize;
        int remainNeedSize = size;
        int nextFromIndex = 0;
        while (rt.size() < size) {
            int index = nextFromIndex + RANDOM.nextInt(remainSourceSize / remainNeedSize);
            rt.add(source.get(index));
            --remainNeedSize;
            nextFromIndex = index + 1;
            remainSourceSize = sourceSize - nextFromIndex;
        }
        return rt;
    }

    private Object readResolve() {
        return INSTANCE;
    }
}

