/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.coll;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.magicall.support.lang.java.Kit;
import me.magicall.support.lang.java.ObjKit;

public final class MapKit
extends Kit<Map<?, ?>>
implements Serializable {
    private static final long serialVersionUID = 1689123743472449851L;
    private static final List<Class<?>> SUPPORTED_CLASSES = Collections.singletonList(Map.class);
    public static final MapKit INSTANCE = new MapKit();

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public boolean isEmpty(Map<?, ?> source) {
        return source == null || source.isEmpty();
    }

    @Override
    public Stream<Class<?>> supportedClasses() {
        return SUPPORTED_CLASSES.stream();
    }

    @Override
    public Map<?, ?> parse(String source) {
        return null;
    }

    @Override
    public <K, V> Map<K, V> emptyVal() {
        return Collections.emptyMap();
    }

    @Override
    public boolean greater(Map<?, ?> source, Map<?, ?> target) {
        if (source == null) {
            return false;
        }
        if (target == null) {
            return true;
        }
        return source.size() > target.size() && source.entrySet().containsAll(target.entrySet());
    }

    @Override
    public boolean greaterEquals(Map<?, ?> source, Map<?, ?> target) {
        if (target == null) {
            return true;
        }
        if (source == null) {
            return false;
        }
        return source.size() >= target.size() && source.entrySet().containsAll(target.entrySet());
    }

    public static <K, V> Map<K, V> cast(Map<?, ?> source) {
        return source;
    }

    public boolean deepEquals(Map<?, ?> map1, Map<?, ?> map2) {
        if (this.isEmpty(map1) && this.isEmpty(map2)) {
            return true;
        }
        for (Map.Entry<?, ?> e : map1.entrySet()) {
            Object v2;
            Object v1 = e.getValue();
            if (ObjKit.deepEquals(v1, v2 = map2.get(e.getKey()))) continue;
            return false;
        }
        return true;
    }

    public <K, V> Map.Entry<K, V> getEntry(Map<K, V> map, int targetIndex) {
        if (map == null) {
            return null;
        }
        if (targetIndex >= map.size()) {
            return null;
        }
        int index = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (index == targetIndex) {
                return entry;
            }
            ++index;
        }
        return null;
    }

    static <A, B, D> Map<A, D> remapVal(Map<A, B> source, Function<? super Map.Entry<A, B>, ? extends D> valMapper) {
        return MapKit.remap(source, Map.Entry::getKey, valMapper);
    }

    static <A, B, C, D> Map<C, D> remap(Map<A, B> source, Function<? super Map.Entry<A, B>, ? extends C> keyMapper, Function<? super Map.Entry<A, B>, ? extends D> valMapper) {
        return source.entrySet().stream().collect(Collectors.toMap(keyMapper, valMapper));
    }

    static <K, V> Map<K, V> map(Stream<? extends K> source, Function<? super K, ? extends V> valueMapper) {
        return source.collect(Collectors.toMap(Function.identity(), valueMapper));
    }
}

