/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.coll;

import java.util.AbstractList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.RandomAccess;

public class MapList<E>
extends AbstractList<E>
implements List<E>,
RandomAccess {
    private static final Object USE_AS_NULL_WHEN_DEF_VAL_IS_NOT_NULL = new Object();
    private final Map<Integer, Object> map;
    private int size;
    private E defVal;

    public MapList(Map<Integer, Object> map, int size, E defVal) {
        this.map = map;
        this.size = size;
        this.defVal = defVal;
    }

    public MapList(Map<Integer, Object> map, int size) {
        this(map, size, null);
    }

    public MapList(int size, E defVal) {
        this(new HashMap<Integer, Object>(), size, defVal);
    }

    public MapList(E defVal) {
        this(0, defVal);
    }

    public MapList(int size) {
        this(size, null);
    }

    public MapList() {
        this(0);
    }

    private static void rangeCheck(int index, int min, int max) {
        if (index < min || index >= max) {
            throw new IndexOutOfBoundsException("Index: " + index + ", min: " + min + ", max:" + max);
        }
    }

    public void fillTo(int toSize) {
        if (this.size < toSize) {
            this.size = toSize;
        }
    }

    public void fillTo(int index, E e) {
        if (index > this.size) {
            this.fillTo(index);
        }
        this.set(index, e);
    }

    @Override
    public E get(int index) {
        this.rangeCheck(index);
        return this.get0(index);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void add(int index, E element) {
        ++this.size;
        this.rangeCheck(index);
        if (index == this.size) {
            this.put(index, element);
        } else {
            E value = element;
            for (int i = index; i < this.size; ++i) {
                value = this.put(i, value);
            }
        }
    }

    @Override
    public E remove(int index) {
        this.rangeCheck(index);
        --this.size;
        if (index == this.size) {
            return this.checkValue(this.map.remove(index));
        }
        E value = this.getDefaultValue();
        for (int i = this.size; i >= index; --i) {
            value = this.put(index, value);
        }
        return value;
    }

    @Override
    public E set(int index, E element) {
        this.rangeCheck(index);
        return this.put(index, element);
    }

    @Override
    public void clear() {
        this.map.clear();
        this.size = 0;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        int removeCount = toIndex - fromIndex;
        int finalSize = this.size - removeCount;
        int index = fromIndex;
        for (int i = toIndex; i < this.size; ++i) {
            Object v = this.map.remove(i);
            assert (v != null);
            this.map.put(index, v);
            ++index;
        }
        while (index < toIndex) {
            this.map.remove(index);
            ++index;
        }
        this.size = finalSize;
    }

    private E checkValue(Object obj) {
        if (Objects.equals(obj, USE_AS_NULL_WHEN_DEF_VAL_IS_NOT_NULL)) {
            assert (this.getDefaultValue() != null);
            return null;
        }
        if (obj == null) {
            return this.getDefaultValue();
        }
        return (E)obj;
    }

    private E put(int index, E element) {
        if (element == null) {
            if (this.getDefaultValue() == null) {
                return this.remove0(index);
            }
            return this.putNullElement(index);
        }
        return this.checkValue(this.map.put(index, element));
    }

    private E get0(int index) {
        return this.checkValue(this.map.get(index));
    }

    private E remove0(int index) {
        return this.checkValue(this.map.remove(index));
    }

    private E putNullElement(int index) {
        return this.checkValue(this.map.put(index, USE_AS_NULL_WHEN_DEF_VAL_IS_NOT_NULL));
    }

    private void rangeCheck(int index) {
        MapList.rangeCheck(index, 0, this.size());
    }

    public E getDefaultValue() {
        return this.defVal;
    }

    public void setDefaultValue(E defaultValue) {
        this.defVal = defaultValue;
    }
}

