/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.coll;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import me.magicall.support.coll.DescendingSet;
import me.magicall.support.coll.NavigableSubSet;
import me.magicall.support.coll.SortedSetSupport;

public interface NavigableSetSupport<E>
extends NavigableSet<E>,
SortedSetSupport<E> {
    @Override
    default public E pollFirst() {
        Object first = this.firstOrNull();
        if (first == null) {
            return null;
        }
        this.remove(first);
        return first;
    }

    @Override
    default public E pollLast() {
        Object last = this.lastOrNull();
        if (last == null) {
            return null;
        }
        this.remove(last);
        return last;
    }

    @Override
    default public NavigableSet<E> descendingSet() {
        return new DescendingSet(this);
    }

    @Override
    default public Iterator<E> descendingIterator() {
        return this.descendingSet().iterator();
    }

    @Override
    default public NavigableSet<E> headSet(E toElement) {
        return this.headSet(toElement, false);
    }

    @Override
    default public NavigableSet<E> headSet(E toElement, boolean inclusive) {
        return this.subSet(this.firstOrNull(), true, (Object)toElement, inclusive);
    }

    @Override
    default public NavigableSet<E> tailSet(E fromElement) {
        return this.tailSet(fromElement, true);
    }

    @Override
    default public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        return this.subSet((Object)fromElement, inclusive, this.lastOrNull(), true);
    }

    @Override
    default public E lower(E target) {
        Comparator comparator = this.nonNullComparator();
        E last = null;
        for (Object e : this) {
            int compare = comparator.compare(e, target);
            if (compare < 0) {
                last = e;
                continue;
            }
            return last;
        }
        return null;
    }

    @Override
    default public E floor(E target) {
        Comparator comparator = this.nonNullComparator();
        E last = null;
        for (Object e : this) {
            int compare = comparator.compare(e, target);
            if (compare == 0) {
                return e;
            }
            if (compare < 0) {
                last = e;
                continue;
            }
            return last;
        }
        return null;
    }

    @Override
    default public E higher(E target) {
        Comparator comparator = this.nonNullComparator();
        for (Object e : this) {
            int compare = comparator.compare(e, target);
            if (compare <= 0) continue;
            return e;
        }
        return null;
    }

    @Override
    default public E ceiling(E target) {
        Comparator comparator = this.nonNullComparator();
        for (Object e : this) {
            int compare = comparator.compare(e, target);
            if (compare < 0) continue;
            return e;
        }
        return null;
    }

    @Override
    default public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return new NavigableSubSet<E>(this, fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    default public NavigableSet<E> subSet(E fromElement, E toElement) {
        return this.subSet((Object)fromElement, true, (Object)toElement, false);
    }
}

