/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.coll;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.magicall.support.relation.Parent;

@FunctionalInterface
public interface NodeWalker {
    public static final NodeWalker DEEP_FIRST = new NodeWalker(){

        @Override
        public <T> Stream<T> walk(T node, Function<T, Stream<? extends T>> nextNodesSupplier) {
            LinkedList waiting = Lists.newLinkedList();
            return Stream.iterate(node, Objects::nonNull, curNode -> {
                waiting.addAll(0, ((Stream)nextNodesSupplier.apply(curNode)).collect(Collectors.toList()));
                return waiting.poll();
            });
        }
    };
    public static final NodeWalker WIDE_FIRST = new NodeWalker(){

        @Override
        public <T> Stream<T> walk(T node, Function<T, Stream<? extends T>> nextNodesSupplier) {
            LinkedList waiting = Lists.newLinkedList();
            return Stream.iterate(node, curNode -> curNode != null || !waiting.isEmpty(), curNode -> {
                ((Stream)nextNodesSupplier.apply(curNode)).forEach(waiting::add);
                return waiting.poll();
            });
        }
    };

    public <T> Stream<T> walk(T var1, Function<T, Stream<? extends T>> var2);

    default public <T extends Parent<T>> Stream<T> walk(T node) {
        return this.walk(node, Parent::children);
    }

    public static NodeWalker deepFirst() {
        return DEEP_FIRST;
    }

    public static NodeWalker wideFirst() {
        return WIDE_FIRST;
    }
}

