/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.coll;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import me.magicall.support.coll.SubSet;

public interface SortedSetSupport<E>
extends SortedSet<E> {
    @Override
    default public int size() {
        int rt = 0;
        for (Object ignored : this) {
            if (++rt != Integer.MAX_VALUE) continue;
            return Integer.MAX_VALUE;
        }
        return rt;
    }

    @Override
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    default public SortedSet<E> headSet(E toElement) {
        return this.subSet(null, true, toElement, false);
    }

    @Override
    default public SortedSet<E> tailSet(E fromElement) {
        return this.subSet(fromElement, true, null, true);
    }

    @Override
    default public SortedSet<E> subSet(E fromElement, E toElement) {
        return this.subSet(fromElement, true, toElement, false);
    }

    default public SortedSet<E> subSet(E fromElement, boolean includingFrom, E toElement, boolean includingTo) {
        return new SubSet<E>(this, fromElement, includingFrom, toElement, includingTo);
    }

    @Override
    default public E first() {
        E e = this.firstOrNull();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    default public E firstOrNull() {
        Iterator iterator = this.iterator();
        return iterator.hasNext() ? (E)iterator.next() : null;
    }

    @Override
    default public E last() {
        E e = this.lastOrNull();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    default public E lastOrNull() {
        E next = null;
        for (Object e : this) {
            next = e;
        }
        return next;
    }

    default public Comparator<? super E> nonNullComparator() {
        return SortedSetSupport.nonNullComparator(this);
    }

    public static <E> Comparator<? super E> nonNullComparator(SortedSet<E> sortedSet) {
        Comparator<E> comparator = sortedSet.comparator();
        return comparator == null ? Comparator.naturalOrder() : comparator;
    }

    public static <E> Comparator<? super E> checkComparator(Comparator<? super E> comparator, E element) {
        if (comparator == null) {
            if (!(element instanceof Comparable)) {
                throw new ClassCastException();
            }
            return Comparator.naturalOrder();
        }
        return comparator;
    }

    public static <E> int countElementsStrictBefore(SortedSet<E> sortedSet, E target) {
        return SortedSetSupport.countElementsBefore(sortedSet, target, true);
    }

    public static <E> int countElementsBefore(SortedSet<E> sortedSet, E target, boolean includingTarget) {
        Comparator comparator = SortedSetSupport.checkComparator(sortedSet.comparator(), target);
        return (int)sortedSet.stream().mapToInt(e -> comparator.compare(e, target)).takeWhile(compareResult -> (compareResult != 0 || includingTarget) && compareResult <= 0).count();
    }
}

