/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.coll;

import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import me.magicall.support.coll.EmptyIterator;
import me.magicall.support.coll.SortedSetSupport;
import me.magicall.support.exception.NullValException;

public class SubSet<E>
extends AbstractSet<E>
implements SortedSetSupport<E> {
    protected final SortedSet<E> raw;
    protected final E fromElement;
    protected final boolean includingFrom;
    protected final E toElement;
    protected final boolean includingTo;

    public SubSet(SortedSet<E> raw, E fromElement, boolean includingFrom, E toElement, boolean includingTo) {
        if (fromElement == null && toElement == null) {
            throw new NullValException("fromElement & toElement");
        }
        this.raw = raw;
        this.fromElement = fromElement;
        this.includingFrom = includingFrom;
        this.toElement = toElement;
        this.includingTo = includingTo;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.raw.comparator();
    }

    protected Comparator<? super E> checkComparator() {
        return SortedSetSupport.checkComparator(this.comparator(), this.fromElement == null ? this.toElement : this.fromElement);
    }

    @Override
    public SubSet<E> subSet(E fromElement, boolean includingFrom, E toElement, boolean includingTo) {
        Comparator<E> comparator = this.checkComparator();
        if (comparator.compare(fromElement, toElement) > 0) {
            throw new IllegalArgumentException("fromElement > toElement");
        }
        if (this.fromElement != null && (comparator.compare(fromElement, this.fromElement) < 0 || !this.includingFrom && this.fromElement.equals(fromElement))) {
            throw new IllegalArgumentException("fromElement out of range");
        }
        if (this.toElement != null && (comparator.compare(toElement, this.toElement) > 0 || !this.includingTo && this.toElement.equals(toElement))) {
            throw new IllegalArgumentException("toElement out of range");
        }
        return new SubSet<E>(this.raw, fromElement, includingFrom, toElement, includingTo);
    }

    @Override
    public Iterator<E> iterator() {
        Comparator<E> comparator = this.checkComparator();
        Iterator iterator = this.raw.iterator();
        Object first = null;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!this.outOfFromElement(comparator, e)) continue;
            if (this.outOfToElement(comparator, e)) break;
            first = e;
            break;
        }
        if (first == null) {
            return EmptyIterator.instance();
        }
        return new SubSetIterator(first, iterator);
    }

    private boolean outOfFromElement(Comparator<? super E> comparator, E e) {
        int compareFrom = comparator.compare(e, this.fromElement);
        return compareFrom == 0 && this.includingFrom || compareFrom > 0;
    }

    private boolean outOfToElement(Comparator<? super E> comparator, E e) {
        int compareTo = comparator.compare(e, this.toElement);
        return compareTo == 0 && !this.includingTo || compareTo > 0;
    }

    @Override
    public int size() {
        return SortedSetSupport.super.size();
    }

    protected class SubSetIterator
    implements Iterator<E> {
        protected final Iterator<E> rawIterator;
        protected E cur;

        protected SubSetIterator(E first, Iterator<E> rawIterator) {
            if (first == null) {
                throw new NullValException("first");
            }
            this.cur = first;
            this.rawIterator = rawIterator;
        }

        @Override
        public boolean hasNext() {
            return this.cur != null;
        }

        @Override
        public E next() {
            if (this.cur == null) {
                throw new NoSuchElementException();
            }
            Object rt = this.cur;
            if (this.rawIterator.hasNext()) {
                Object rawNext = this.rawIterator.next();
                this.cur = SubSet.this.outOfToElement(SubSet.this.nonNullComparator(), rawNext) ? null : rawNext;
            } else {
                this.cur = null;
            }
            return rt;
        }

        @Override
        public void remove() {
            SubSet.this.raw.remove(this.cur);
        }
    }
}

