/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.coll;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.magicall.support.coll.Tree;
import me.magicall.support.coll.TreeNodeWrapper;
import me.magicall.support.coll.TreeTemplate;
import me.magicall.support.lang.java.Kits;

class SubTree<E>
extends TreeTemplate<E> {
    private final SubTreeRootNode root;
    private final int layerIndex;

    SubTree(Tree.TreeNode<E> rootNode) {
        this.layerIndex = rootNode.getLayer();
        this.root = new SubTreeRootNode(rootNode);
    }

    @Override
    public Tree.TreeNode<E> getRoot() {
        return this.root;
    }

    private class SubTreeRootNode
    extends SubTreeNode {
        private SubTreeRootNode(Tree.TreeNode<E> rootNode) {
            super(rootNode);
        }

        @Override
        public Collection<Tree.TreeNode<E>> getSiblings() {
            return Kits.COLL.emptyVal();
        }

        @Override
        public boolean isRoot() {
            return true;
        }

        @Override
        public List<Tree.TreeNode<E>> pathFromRoot() {
            return Kits.LIST.emptyVal();
        }

        @Override
        public List<Tree.TreeNode<E>> pathToRoot() {
            return Kits.LIST.emptyVal();
        }

        @Override
        public Tree<E> treeFromMe() {
            return SubTree.this;
        }

        @Override
        public Tree.TreeNode<E> parent() {
            return null;
        }

        @Override
        public int getLayer() {
            return 0;
        }
    }

    private class SubTreeNode
    extends TreeNodeWrapper<E> {
        SubTreeNode(Tree.TreeNode<E> raw) {
            super(raw);
        }

        @Override
        public Tree.TreeNode<E> parent() {
            Tree.TreeNode parent = (Tree.TreeNode)this.raw.parent();
            if (SubTree.this.root.unwrap().equals(parent)) {
                return SubTree.this.root;
            }
            return this.wrap(parent);
        }

        @Override
        public boolean isRoot() {
            return false;
        }

        @Override
        public Stream<? extends Tree.TreeNode<E>> children() {
            return this.raw.children().map(this::wrap);
        }

        @Override
        public Collection<Tree.TreeNode<E>> getLeafNodes() {
            return this.raw.getLeafNodes().stream().map(this::wrap).collect(Collectors.toList());
        }

        @Override
        public Collection<Tree.TreeNode<E>> getDescendants() {
            return this.raw.getDescendants().stream().map(this::wrap).collect(Collectors.toList());
        }

        @Override
        public Collection<Tree.TreeNode<E>> getSiblings() {
            return this.raw.getSiblings().stream().map(this::wrap).collect(Collectors.toList());
        }

        @Override
        public List<Tree.TreeNode<E>> pathFromRoot() {
            return this.raw.pathFromRoot().stream().map(this::wrap).collect(Collectors.toList());
        }

        @Override
        public List<Tree.TreeNode<E>> pathToRoot() {
            return this.raw.pathToRoot().stream().map(this::wrap).collect(Collectors.toList());
        }

        @Override
        public int getLayer() {
            return this.raw.getLayer() - SubTree.this.layerIndex;
        }

        private SubTreeNode wrap(Tree.TreeNode<E> raw) {
            return new SubTreeNode(raw);
        }
    }
}

