/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.coll;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.magicall.support.coll.SubTree;
import me.magicall.support.coll.TreeWalker;
import me.magicall.support.lang.java.Kits;
import me.magicall.support.relation.Child;
import me.magicall.support.relation.Parent;

@FunctionalInterface
public interface Tree<E>
extends Collection<E> {
    public TreeNode<E> getRoot();

    default public Stream<TreeNode<E>> nodeStream() {
        return TreeWalker.wideFirst().walk(this);
    }

    default public Stream<E> elementStream() {
        return this.nodeStream().map(TreeNode::getElement);
    }

    @Override
    default public Stream<E> stream() {
        return this.elementStream();
    }

    default public int countLayers() {
        return this.isEmpty() ? 0 : this.getRoot().countTreeLayers();
    }

    default public Collection<TreeNode<E>> getLeafNodes() {
        return this.nodeStream().filter(TreeNode::isLeaf).collect(Collectors.toList());
    }

    default public int countLeaves() {
        return this.getLeafNodes().size();
    }

    @Override
    default public int size() {
        return (int)Math.min(this.nodeStream().count(), Integer.MAX_VALUE);
    }

    @Override
    default public boolean isEmpty() {
        return this.getRoot() == null;
    }

    @Override
    default public Iterator<E> iterator() {
        final Iterator raw = this.nodeStream().iterator();
        return new Iterator<E>(){
            TreeNode<E> curNode;

            @Override
            public boolean hasNext() {
                return raw.hasNext();
            }

            @Override
            public E next() {
                this.curNode = (TreeNode)raw.next();
                return this.curNode.getElement();
            }

            @Override
            public void remove() {
                raw.remove();
                Tree.this.remove(this.curNode.getElement());
            }
        };
    }

    @Override
    default public boolean contains(Object o) {
        return this.nodeStream().anyMatch(n -> Objects.equals(n.getElement(), o));
    }

    @Override
    default public boolean containsAll(Collection<?> c) {
        return c.stream().allMatch(this::contains);
    }

    @Override
    default public Object[] toArray() {
        return this.elementStream().toArray();
    }

    @Override
    default public <T> T[] toArray(T[] a) {
        return this.elementStream().collect(Collectors.toList()).toArray(a);
    }

    @Override
    default public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public boolean addAll(Collection<? extends E> c) {
        return Objects.requireNonNull(c).stream().map(this::add).reduce((preResult, addedResult) -> preResult != false && addedResult != false).orElse(false);
    }

    @Override
    default public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public boolean removeAll(Collection<?> c) {
        Objects.requireNonNull(c);
        boolean modified = false;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            if (!c.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    default public boolean retainAll(Collection<?> c) {
        Objects.requireNonNull(c);
        boolean modified = false;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            if (c.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    default public void clear() {
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    public static interface TreeNode<E>
    extends Child<TreeNode<E>>,
    Parent<TreeNode<E>> {
        public E getElement();

        default public E setElement(E newElement) {
            throw new UnsupportedOperationException();
        }

        default public E clearElement() {
            return this.setElement(null);
        }

        @Override
        default public TreeNode<E> adopt(TreeNode<E> node) {
            return this.addSubTree(node.treeFromMe());
        }

        default public List<? extends TreeNode<E>> pathToRoot() {
            return Stream.iterate((TreeNode)this.parent(), Objects::nonNull, Child::parent).collect(Collectors.toList());
        }

        default public List<? extends TreeNode<E>> pathFromRoot() {
            LinkedList rt = Lists.newLinkedList();
            Stream.iterate((TreeNode)this.parent(), Objects::nonNull, Child::parent).forEach(n -> rt.add(0, n));
            return rt;
        }

        @Override
        default public boolean isChildOf(TreeNode<E> target) {
            if (this.isRoot()) {
                return false;
            }
            return target.children().anyMatch(this::equals) || ((TreeNode)this.parent()).isChildOf(target);
        }

        default public int getLayer() {
            return this.pathToRoot().size();
        }

        @Override
        public Stream<? extends TreeNode<E>> children();

        default public boolean isLeaf() {
            return this.children().count() == 0L;
        }

        default public TreeNode<E> child(E child) {
            throw new UnsupportedOperationException();
        }

        default public Map<E, TreeNode<E>> children(Collection<E> children) {
            return children.stream().collect(Collectors.toMap(Function.identity(), this::child));
        }

        default public boolean removeChild(Predicate<? super TreeNode<?>> predicate) {
            throw new UnsupportedOperationException();
        }

        default public boolean removeChildren() {
            long count = this.children().count();
            boolean rt = true;
            int i = 0;
            while ((long)i < count) {
                rt = rt && this.removeChild(e -> true);
                ++i;
            }
            return rt;
        }

        default public Collection<? extends TreeNode<E>> getDescendants() {
            return this.treeFromMe().nodeStream().skip(1L).collect(Collectors.toList());
        }

        default public int countDescendants() {
            return this.getDescendants().size();
        }

        default public Collection<? extends TreeNode<E>> getLeafNodes() {
            return this.treeFromMe().getLeafNodes();
        }

        default public Tree<E> treeFromMe() {
            return new SubTree(this);
        }

        private int countTreeLayers() {
            return this.children().map(TreeNode::countTreeLayers).reduce(Math::max).orElse(0) + 1;
        }

        default public Collection<? extends Tree<E>> getSubTrees() {
            return this.children().map(TreeNode::treeFromMe).collect(Collectors.toList());
        }

        default public TreeNode<E> addSubTree(Tree<E> tree) {
            throw new UnsupportedOperationException();
        }

        default public Collection<? extends TreeNode<E>> getSiblings() {
            if (this.isRoot()) {
                return Kits.COLL.emptyVal();
            }
            return ((TreeNode)this.parent()).children().filter(n -> !this.equals(n)).collect(Collectors.toList());
        }
    }
}

