/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.exception;

import java.io.Serializable;
import java.util.Objects;
import me.magicall.support.Identified;
import me.magicall.support.Named;
import me.magicall.support.Thing;

public class OperationNotAvailableException
extends RuntimeException {
    private static final long serialVersionUID = -6336035506223253531L;
    public static final Operator UNKNOWN_OPERATOR = Operator.UNKNOWN;
    private final Operator operator;
    private final Named operation;
    private final Thing target;

    public OperationNotAvailableException(Operator operator, Named operation, Thing target) {
        super("Operator '" + operator + "' doing operation '" + operation.name() + "' to target '" + target + "' is not available.");
        this.operator = operator;
        this.operation = operation;
        this.target = target;
    }

    public OperationNotAvailableException(Named operation, Thing target) {
        this(UNKNOWN_OPERATOR, operation, target);
    }

    public OperationNotAvailableException(Operator operator, String operationName, Thing target) {
        this(operator, Named.of(operationName), target);
    }

    public OperationNotAvailableException(String operationName, Thing target) {
        this(UNKNOWN_OPERATOR, operationName, target);
    }

    public OperationNotAvailableException(Operator operator, Named operation, Thing target, Throwable cause) {
        this(operator, operation, target);
        this.initCause(cause);
    }

    public OperationNotAvailableException(Named operation, Thing target, Throwable cause) {
        this(UNKNOWN_OPERATOR, operation, target, cause);
    }

    public OperationNotAvailableException(Operator operator, String operationName, Thing target, Throwable cause) {
        this(operator, Named.of(operationName), target, cause);
    }

    public OperationNotAvailableException(String operationName, Thing target, Throwable cause) {
        this(UNKNOWN_OPERATOR, operationName, target, cause);
    }

    @Override
    public final synchronized Throwable initCause(Throwable cause) {
        return super.initCause(cause);
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Named getOperation() {
        return this.operation;
    }

    public Object getTarget() {
        return this.target;
    }

    public static class Operator
    implements Serializable {
        private static final long serialVersionUID = -5458937896196316752L;
        public static final Operator UNKNOWN = new Operator();
        private final Thing.ThingDto thing = new Thing.ThingDto();
        private Operator principal;

        private Operator() {
        }

        public Operator getPrincipal() {
            return this.principal;
        }

        public String getType() {
            return this.thing.type();
        }

        public String getId() {
            return this.thing.idInType();
        }

        public Operator withId(String id) {
            this.thing.idInType = id;
            return this;
        }

        public Operator withType(String type) {
            this.thing.type = type;
            return this;
        }

        public Operator forPrincipal(Operator principal) {
            this.principal = principal;
            return this;
        }

        public Operator delegating(Object principal) {
            if (principal instanceof Operator) {
                this.principal = (Operator)principal;
            } else {
                Object id = principal instanceof Identified ? ((Identified)principal).id() : Integer.valueOf(Objects.hashCode(principal));
                this.principal = Operator.ofType(principal.getClass().getName()).withId(String.valueOf(id));
            }
            return this;
        }

        public static Operator ofType(String type) {
            return new Operator().withType(type);
        }

        public static Operator ofId(String id) {
            return new Operator().withId(id);
        }
    }
}

