/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.io;

public final class ByteArrayBuffer {
    private byte[] buffer;
    private int len;

    public ByteArrayBuffer(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Buffer capacity may not be negative");
        }
        this.buffer = new byte[capacity];
    }

    private void expand(int newLen) {
        byte[] newBuffer = new byte[Math.max(this.buffer.length << 1, newLen)];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.len);
        this.buffer = newBuffer;
    }

    public void append(byte[] bytes, int off, int length) {
        if (bytes == null) {
            return;
        }
        if (off < 0 || off > bytes.length || length < 0 || off + length > bytes.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        int newLen = this.len + length;
        if (newLen > this.buffer.length) {
            this.expand(newLen);
        }
        System.arraycopy(bytes, off, this.buffer, this.len, length);
        this.len = newLen;
    }

    public void append(int val) {
        int newLen = this.len + 1;
        if (newLen > this.buffer.length) {
            this.expand(newLen);
        }
        this.buffer[this.len] = (byte)val;
        this.len = newLen;
    }

    public void append(char[] chars, int off, int length) {
        if (chars == null) {
            return;
        }
        if (off < 0 || off > chars.length || length < 0 || off + length > chars.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        int newLen = this.len + length;
        if (newLen > this.buffer.length) {
            this.expand(newLen);
        }
        int i1 = off;
        for (int i2 = this.len; i2 < newLen; ++i2) {
            this.buffer[i2] = (byte)chars[i1];
            ++i1;
        }
        this.len = newLen;
    }

    public void clear() {
        this.len = 0;
    }

    public byte[] toByteArray() {
        byte[] b = new byte[this.len];
        if (this.len > 0) {
            System.arraycopy(this.buffer, 0, b, 0, this.len);
        }
        return b;
    }

    public int byteAt(int index) {
        return this.buffer[index];
    }

    public int capacity() {
        return this.buffer.length;
    }

    public int length() {
        return this.len;
    }

    public void setLength(int length) {
        if (length < 0 || length > this.buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        this.len = length;
    }

    public boolean isEmpty() {
        return this.len == 0;
    }

    public boolean isFull() {
        return this.len == this.buffer.length;
    }
}

