/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import me.magicall.support.computer.DataType;

public enum FileType implements FilenameFilter,
FileFilter
{
    JPG(DataType.IMG, "jpeg"),
    GIF(DataType.IMG, new String[0]),
    BMP(DataType.IMG, new String[0]),
    ICO(DataType.IMG, new String[0]),
    PNG(DataType.IMG, new String[0]),
    TXT(DataType.TEXT, new String[0]),
    XML(DataType.TEXT, new String[0]),
    HTML(DataType.TEXT, "htm"),
    PROPERTIES(DataType.TEXT, new String[0]),
    JSP(DataType.TEXT, new String[0]),
    JS(DataType.TEXT, new String[0]),
    ASP(DataType.TEXT, new String[0]),
    PHP(DataType.TEXT, new String[0]),
    PY(DataType.TEXT, new String[0]),
    WAV(DataType.AUDIO, new String[0]),
    MP3(DataType.AUDIO, new String[0]),
    MP4(DataType.VIDEO, new String[0]),
    RMVB(DataType.VIDEO, new String[0]),
    BIN(DataType.BINARY, new String[0]);

    private static final Map<String, FileType> SUFFIX_MAP;
    private final DataType dataType;
    private final String[] suffixes;

    private FileType(DataType dataType, String ... otherSuffixes) {
        this.dataType = dataType;
        this.suffixes = new String[1 + otherSuffixes.length];
        this.suffixes[0] = "." + this.name().toLowerCase();
        IntStream.range(0, otherSuffixes.length).forEach(i -> {
            this.suffixes[i + 1] = "." + otherSuffixes[i].toLowerCase();
        });
    }

    public static String getNameWithoutSuffix(File file) {
        String fileName = file.getName();
        int lastIndex = fileName.lastIndexOf(46);
        if (lastIndex == -1) {
            return fileName;
        }
        return fileName.substring(0, lastIndex);
    }

    public static FileType getByFileName(String fileName) {
        if (fileName.indexOf(46) >= 0) {
            return SUFFIX_MAP.get(fileName.substring(fileName.lastIndexOf(46)).toLowerCase());
        }
        return null;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public String[] getSuffixes() {
        return (String[])this.suffixes.clone();
    }

    @Override
    public boolean accept(File dir, String name) {
        return Arrays.stream(this.suffixes).anyMatch(name::endsWith);
    }

    @Override
    public boolean accept(File file) {
        return this.accept(null, file.getName());
    }

    static {
        SUFFIX_MAP = new HashMap<String, FileType>();
        Arrays.stream(FileType.values()).forEach(fileType -> Arrays.stream(fileType.suffixes).forEach(s -> SUFFIX_MAP.put((String)s, (FileType)fileType)));
    }
}

