/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.io;

import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.magicall.support.exception.ExceptionHandler;
import me.magicall.support.io.CloseableCreator;
import me.magicall.support.io.CloseableIOCallback;
import me.magicall.support.lang.java.FinallyCallback;

public class IOKit {
    public static Map<Closeable, IOException> close(Collection<Closeable> closeables) {
        HashMap rt = Maps.newHashMap();
        closeables.stream().filter(Objects::nonNull).forEach(closeable -> {
            try {
                closeable.close();
            }
            catch (IOException e) {
                rt.put(closeable, e);
            }
        });
        return rt;
    }

    public static Map<Closeable, IOException> close(Closeable ... closeables) {
        return IOKit.close(Arrays.asList(closeables));
    }

    public static IOException close(Closeable closeable) {
        return IOKit.close(Collections.singleton(closeable)).get(closeable);
    }

    public static void closeSilently(Closeable ... closeables) {
        IOKit.close(closeables);
    }

    public static void closeSilently(Collection<Closeable> closeables) {
        IOKit.close(closeables);
    }

    public static File ensureFile(String path) {
        File f = new File(path);
        if (f.exists()) {
            return f;
        }
        File dir = f.getParentFile();
        if (!dir.exists() && !IOKit.tryMakeDirs(dir)) {
            return null;
        }
        try {
            if (f.createNewFile()) {
                return f;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean tryMakeDirs(File dir) {
        if (dir.exists()) {
            return !dir.isFile();
        }
        return dir.mkdirs();
    }

    @Deprecated
    public static <C extends Closeable> void io(CloseableCreator<C> creator, CloseableIOCallback<C> callback, ExceptionHandler<IOException> exceptionHandler) {
        CloseableCreatorWithFinallyCloseCallback<C> c = new CloseableCreatorWithFinallyCloseCallback<C>(creator);
        IOKit.io(c, callback, exceptionHandler, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static <C extends Closeable> void io(CloseableCreator<C> creator, CloseableIOCallback<C> callback, ExceptionHandler<IOException> exceptionHandler, FinallyCallback finallyCallback) {
        try {
            C closeable = creator.create();
            callback.callback(closeable);
        }
        catch (IOException e) {
            if (exceptionHandler != null) {
                exceptionHandler.handle(e);
            }
        }
        finally {
            if (finallyCallback != null) {
                finallyCallback.finallyExecute();
            }
        }
    }

    @Deprecated
    private static class CloseableCreatorWithFinallyCloseCallback<C extends Closeable>
    implements CloseableCreator<C>,
    FinallyCallback {
        private final CloseableCreator<C> creator;
        private C closeable;

        CloseableCreatorWithFinallyCloseCallback(CloseableCreator<C> creator) {
            this.creator = creator;
        }

        @Override
        public void finallyExecute() {
            IOKit.close(this.closeable);
        }

        @Override
        public C create() throws IOException {
            this.closeable = this.creator.create();
            return this.closeable;
        }
    }
}

