/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang;

import java.util.ArrayList;
import java.util.List;
import me.magicall.support.lang.java.Kits;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum LabelStyle {
    CAMEL{

        @Override
        public boolean isWordEdge(char c) {
            return Character.isUpperCase(c);
        }

        @Override
        public void handleNextWordFirstChar(StringBuilder sb, char nextWordHeaderChar) {
            sb.append(Character.toUpperCase(nextWordHeaderChar));
        }

        @Override
        void handleFirstChar(StringBuilder sb, char firstChar) {
            sb.append(Character.toLowerCase(firstChar));
        }
    }
    ,
    UNDERLINE_CONNECTOR(Character.valueOf('_')){

        @Override
        void handleFirstChar(StringBuilder sb, char firstChar) {
            sb.append(Character.toLowerCase(firstChar));
        }
    }
    ,
    MINUS_CONNECTOR(Character.valueOf('-')){

        @Override
        void handleFirstChar(StringBuilder sb, char firstChar) {
            sb.append(Character.toUpperCase(firstChar));
        }
    };

    private final Character separator;

    private LabelStyle() {
        this(null);
    }

    private LabelStyle(Character separator) {
        this.separator = separator;
    }

    public boolean isWordEdge(char c) {
        return c == this.getSeparator().charValue();
    }

    void handleNextWordFirstChar(StringBuilder sb, char nextWordHeaderChar) {
        sb.append(this.getSeparator());
        this.handleFirstChar(sb, nextWordHeaderChar);
    }

    void handleFirstChar(StringBuilder sb, char firstChar) {
        sb.append(firstChar);
    }

    public boolean hasSeparator() {
        return this.getSeparator() != null;
    }

    public String convertTo(LabelStyle targetFormat, String source) {
        if (Kits.STR.isEmpty(source)) {
            return source;
        }
        StringBuilder sb = new StringBuilder();
        targetFormat.handleFirstChar(sb, source.charAt(0));
        int len = source.length();
        for (int i = 1; i < len; ++i) {
            char c = source.charAt(i);
            if (this.isWordEdge(c)) {
                if (++i >= source.length()) continue;
                targetFormat.handleNextWordFirstChar(sb, source.charAt(i));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public String[] splitWords(String s) {
        return Kits.STR.isEmpty(s) ? (String[])Kits.STR.emptyArr() : this.listWords(s).toArray(new String[0]);
    }

    public List<String> listWords(String s) {
        ArrayList<String> list = new ArrayList<String>();
        int len = s.length();
        int lastIndex = 0;
        for (int i = 1; i < len; ++i) {
            char c = s.charAt(i);
            if (!this.isWordEdge(c)) continue;
            list.add(s.substring(lastIndex, i));
            lastIndex = this.hasSeparator() ? i + 1 : i;
        }
        list.add(s.substring(lastIndex));
        return list;
    }

    public Character getSeparator() {
        return this.separator;
    }
}

