/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang.java;

import java.lang.reflect.Member;
import java.lang.reflect.Modifier;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum AccessLv {
    PRIVATE{

        @Override
        public boolean checkModifiers(int modifiers) {
            return Modifier.isPrivate(modifiers);
        }
    }
    ,
    DEFAULT{

        @Override
        public boolean checkModifiers(int modifiers) {
            return !PUBLIC.checkModifiers(modifiers) && !PRIVATE.checkModifiers(modifiers) && !PROTECTED.checkModifiers(modifiers);
        }
    }
    ,
    PROTECTED{

        @Override
        public boolean checkModifiers(int modifiers) {
            return Modifier.isProtected(modifiers);
        }
    }
    ,
    PUBLIC{

        @Override
        public boolean checkModifiers(int modifiers) {
            return Modifier.isPublic(modifiers);
        }
    };


    public boolean is(Class<?> c) {
        return this.checkModifiers(c.getModifiers());
    }

    public boolean is(Member member) {
        return this.checkModifiers(member.getModifiers());
    }

    public abstract boolean checkModifiers(int var1);

    public boolean contains(AccessLv other) {
        return this.ordinal() > other.ordinal();
    }

    public static AccessLv of(int modifierFlag) {
        if (Modifier.isPublic(modifierFlag)) {
            return PUBLIC;
        }
        if (Modifier.isProtected(modifierFlag)) {
            return PROTECTED;
        }
        if (Modifier.isPrivate(modifierFlag)) {
            return PRIVATE;
        }
        return DEFAULT;
    }

    public static AccessLv of(Class<?> c) {
        return c == null ? null : AccessLv.of(c.getModifiers());
    }

    public static AccessLv of(Member member) {
        return member == null ? null : AccessLv.of(member.getModifiers());
    }
}

