/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang.java;

import com.google.common.collect.Lists;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import me.magicall.support.lang.java.ClassKit;
import me.magicall.support.lang.java.Kits;
import me.magicall.support.lang.java.ObjKit;
import me.magicall.support.lang.java.PrimitiveKit;

public class ArrKit {
    public static Class<?> arrClass(Class<?> componentType, int dim) {
        return ClassKit.arrClass(componentType, dim);
    }

    public static Object nDimEmptyArr(Class<?> componentType, int dim) {
        return ArrKit.nDimArr(componentType, dim, 0);
    }

    public static Object nDimArr(Class<?> componentType, int dim, int size) {
        if (dim < 1) {
            throw new IllegalArgumentException();
        }
        return Array.newInstance(dim == 1 ? componentType : ArrKit.arrClass(componentType, dim - 1), size);
    }

    public static Class<?> componentType(Class<?> arrClass) {
        return ClassKit.componentType(arrClass);
    }

    public static int dimOfArrayClass(Class<?> arrClass) {
        return ClassKit.dimOfArrayClass(arrClass);
    }

    public static List<Object> asList(Object array) {
        Class<?> c = array.getClass();
        if (c.isArray()) {
            int len = Array.getLength(array);
            if (len == 0) {
                return Kits.LIST.emptyVal();
            }
            List rt = IntStream.range(0, len).mapToObj(i -> Array.get(array, i)).collect(Collectors.toCollection(() -> Lists.newArrayListWithExpectedSize((int)len)));
            return rt;
        }
        return Lists.newArrayList((Object[])new Object[]{array});
    }

    @SafeVarargs
    public static <T> int findInstance(T target, T ... source) {
        int index = 0;
        for (T t : source) {
            if (t == target) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @SafeVarargs
    public static <T> int find(T target, T ... source) {
        int index = 0;
        if (target == null) {
            for (T t : source) {
                if (t == null) {
                    return index;
                }
                ++index;
            }
        } else {
            for (T t : source) {
                if (target.equals(t)) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    @SafeVarargs
    public static <T> T[] asArray(T ... ts) {
        return ts;
    }

    public static boolean deepEquals(Object[] a1, Object ... a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        return ArrKit.deepEquals(a1, a2, null);
    }

    static boolean deepEquals(Object[] a1, Object[] a2, Set<Object> escape) {
        if (escape != null && (escape.contains(a1) || escape.contains(a2))) {
            return false;
        }
        int length = a1.length;
        if (a2.length != length) {
            return false;
        }
        return IntStream.range(0, length).allMatch(i -> ObjKit.deepEquals(a1[i], a2[i], escape));
    }

    @SafeVarargs
    public static <T> T[] sub(int fromIndex, T ... source) {
        if (source == null) {
            return null;
        }
        return ArrKit.sub(fromIndex, source.length, source);
    }

    public static <T> T[] sub(int fromIndex, int toIndex, T ... source) {
        return source == null ? null : Arrays.copyOfRange(source, Math.min(fromIndex, toIndex), Math.max(fromIndex, toIndex));
    }

    public static boolean primitivesArrEquals(Object e1, Object e2) {
        PrimitiveKit ps = Kits.ofPrimitive(e1.getClass().getComponentType().getName());
        return ps.arrEquals(e1, e2);
    }

    @SafeVarargs
    public static <T> int instanceIndexOf(Object target, int fromIndex, int toIndex, T ... source) {
        int e;
        int s;
        if (source == null) {
            return -1;
        }
        if (fromIndex <= toIndex) {
            s = fromIndex;
            e = toIndex;
        } else {
            s = toIndex;
            e = fromIndex;
        }
        int f = Math.max(s, 0);
        int t = Math.min(e, source.length);
        return IntStream.range(f, t).filter(i -> source[i] == target).findFirst().orElse(-1);
    }

    @SafeVarargs
    public static <T> int instanceIndexOf(Object target, int fromIndex, T ... source) {
        if (source == null) {
            return -1;
        }
        return ArrKit.instanceIndexOf(target, fromIndex, source.length, source);
    }

    @SafeVarargs
    public static <T> int instanceIndexOf(Object target, T ... source) {
        return ArrKit.instanceIndexOf(target, 0, source);
    }

    @SafeVarargs
    public static <T> int indexOf(Object target, int fromIndex, int toIndex, T ... source) {
        int e;
        int s;
        if (ArrKit.isEmpty(source)) {
            return -1;
        }
        if (fromIndex <= toIndex) {
            s = fromIndex;
            e = toIndex;
        } else {
            s = toIndex;
            e = fromIndex;
        }
        int f = Math.max(s, 0);
        int t = Math.min(e, source.length);
        if (target == null) {
            return IntStream.range(f, t).filter(i -> source[i] == null).findFirst().orElse(-1);
        }
        return IntStream.range(f, t).filter(i -> ObjKit.deepEquals(target, source[i])).findFirst().orElse(-1);
    }

    @SafeVarargs
    public static <T> int indexOf(Object target, int fromIndex, T ... source) {
        if (source == null) {
            return -1;
        }
        return ArrKit.indexOf(target, fromIndex, source.length, source);
    }

    @SafeVarargs
    public static <T> int indexOf(Object target, T ... source) {
        return ArrKit.indexOf(target, 0, source);
    }

    @SafeVarargs
    public static <T> boolean contains(Object target, int fromIndex, int toIndex, T ... source) {
        return ArrKit.indexOf(target, fromIndex, toIndex, source) > -1;
    }

    @SafeVarargs
    public static <T> boolean contains(Object target, int fromIndex, T ... source) {
        return ArrKit.indexOf(target, fromIndex, source) > -1;
    }

    @SafeVarargs
    public static <T> boolean contains(Object target, T ... source) {
        return ArrKit.indexOf(target, source) > -1;
    }

    @SafeVarargs
    public static <T> boolean containsInstance(Object target, int fromIndex, int toIndex, T ... source) {
        return ArrKit.instanceIndexOf(target, fromIndex, toIndex, source) > -1;
    }

    @SafeVarargs
    public static <T> boolean containsInstance(Object target, int fromIndex, T ... source) {
        return ArrKit.instanceIndexOf(target, fromIndex, source) > -1;
    }

    @SafeVarargs
    public static <T> boolean containsInstance(Object target, T ... source) {
        return ArrKit.instanceIndexOf(target, source) > -1;
    }

    public static <T> void reverse(T[] source, int fromIndex, int toIndex) {
        int s;
        if (source == null) {
            return;
        }
        if (fromIndex <= toIndex) {
            s = fromIndex;
            e = toIndex;
        } else {
            s = toIndex;
            e = fromIndex;
        }
        int i = s;
        for (int j = e - 1; i < j; ++i, --j) {
            ArrKit.swap(source, i, j);
        }
    }

    public static <T> void reverse(T[] source, int fromIndex) {
        if (source == null) {
            return;
        }
        ArrKit.reverse(source, fromIndex, source.length);
    }

    @SafeVarargs
    public static <T> void reverse(T ... source) {
        ArrKit.reverse(source, 0);
    }

    private static <T> void swap(T[] array, int index1, int index2) {
        T o = array[index1];
        array[index1] = array[index2];
        array[index2] = o;
    }

    @SafeVarargs
    public static <T> boolean isEmpty(T ... array) {
        return array == null || array.length == 0;
    }

    @SafeVarargs
    public static <T> List<T> asAddableList(T ... array) {
        if (array == null) {
            return new ArrayList();
        }
        return Stream.of(array).collect(Collectors.toList());
    }

    @SafeVarargs
    public static <T> List<T> asUnmodifiableList(T ... array) {
        return List.of(array);
    }

    public static <T> Class<T[]> arrClass(Class<T> componentType) {
        return ArrKit.arrClass(componentType, 1);
    }

    public static <T> T[] emptyArray(Class<T> clazz) {
        return (Object[])Array.newInstance(clazz, 0);
    }

    @SafeVarargs
    public static <T extends Comparable<T>> T max(Comparator<? super T> comparator, T ... source) {
        return (T)((Comparable)Collections.max(Arrays.asList(source), comparator));
    }

    @SafeVarargs
    public static <T extends Comparable<T>> T max(T ... source) {
        return (T)((Comparable)Collections.max(Arrays.asList(source)));
    }

    @SafeVarargs
    public static <T> T min(Comparator<? super T> comparator, T ... source) {
        return Collections.min(Arrays.asList(source), comparator);
    }

    @SafeVarargs
    public static <T extends Comparable<T>> T min(T ... source) {
        return (T)((Comparable)Collections.min(Arrays.asList(source)));
    }
}

