/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang.java;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import me.magicall.support.exception.NoSuchThingException;
import me.magicall.support.lang.java.ClassKit;
import me.magicall.support.lang.java.Kits;
import me.magicall.support.lang.java.MethodKit;
import me.magicall.support.lang.java.ObjKit;
import me.magicall.support.lang.java.proxy.dynamic.DynamicProxyKit;
import me.magicall.support.lang.java.proxy.dynamic.MapBeanInvocationHandler;

public class BeanKit {
    public static final String SET = "set";
    public static final int SET_LEN = "set".length();
    public static final Predicate<Method> IS_GETTER = BeanKit::isGetter;
    public static final Predicate<Method> IS_EXACT_GETTER = BeanKit::isExactGetter;
    public static final Predicate<Method> IS_BOOL_GETTER_START_WITH_IS = BeanKit::isBoolGetterStartWithIs;
    public static final Predicate<Method> IS_STRICT_SETTER = BeanKit::isStrictSetter;
    private static final int FIELD_NAME_START_INDEX_OF_SETTER = SET_LEN + 1;
    public static final String GET = "get";
    public static final int GET_LEN = "get".length();
    private static final int FIELD_NAME_START_INDEX_OF_GETTER = GET_LEN + 1;
    public static final String IS = "is";
    public static final int IS_LEN = "is".length();
    private static final int FIELD_NAME_START_INDEX_OF_GETTER_USING_IS = IS_LEN + 1;
    private static final Map<Class<?>, Collection<Method>> ALL_GETTERS_WITHOUT_GET_CLASS_CACHE = new ConcurrentHashMap();
    private static final Map<Class<?>, Collection<Method>> ALL_SETTERS_CACHE = new ConcurrentHashMap();

    public static String toGetterName(String fieldName) {
        return GET + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
    }

    public static String toSetterName(String fieldName) {
        return SET + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
    }

    public static String toGetterNameStartWithIs(String fieldName) {
        return IS + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
    }

    public static String getterToFieldName(Method method) {
        String methodName = method.getName();
        if (BeanKit.isExactGetter(method)) {
            return Character.toLowerCase(methodName.charAt(GET_LEN)) + methodName.substring(FIELD_NAME_START_INDEX_OF_GETTER);
        }
        if (BeanKit.isBoolGetterStartWithIs(method)) {
            return Character.toLowerCase(methodName.charAt(IS_LEN)) + methodName.substring(FIELD_NAME_START_INDEX_OF_GETTER_USING_IS);
        }
        return null;
    }

    public static String setterNameToFieldName(String methodName) {
        return Character.toLowerCase(methodName.charAt(SET_LEN)) + methodName.substring(FIELD_NAME_START_INDEX_OF_SETTER);
    }

    public static <T> T newPojo(Class<? extends T> clazz) {
        if (clazz.isInterface()) {
            return DynamicProxyKit.proxy((InvocationHandler)new MapBeanInvocationHandler(), clazz);
        }
        return ClassKit.newInstance(clazz, new Object[0]);
    }

    public static Map<String, Object> flat(Object bean) throws IllegalAccessException {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        BeanKit.putValues(bean, map, null);
        return map;
    }

    private static void putValues(Object bean, Map<String, Object> map, String prefix) throws IllegalAccessException {
        Class<?> cls = bean.getClass();
        for (Field field : cls.getDeclaredFields()) {
            field.setAccessible(true);
            Object value = field.get(bean);
            Object key = prefix == null ? field.getName() : prefix + "." + field.getName();
            if (BeanKit.isValue(value)) {
                map.put((String)key, value);
                continue;
            }
            BeanKit.putValues(value, map, (String)key);
        }
    }

    private static boolean isValue(Object value) {
        if (value == null) {
            return true;
        }
        if (value.getClass() == Object.class) {
            return true;
        }
        return Kits.getAll().stream().filter(kit -> !(kit instanceof ObjKit)).anyMatch(kit -> kit.isSuitForInstance(value));
    }

    public static boolean isGetter(Method method) {
        return BeanKit.isExactGetter(method) || BeanKit.isBoolGetterStartWithIs(method);
    }

    public static boolean isExactGetter(Method method) {
        return method.getDeclaringClass() != Object.class && BeanKit.firstWordMatch(method, GET) && MethodKit.hasNoArg(method) && MethodKit.hasReturn(method);
    }

    public static boolean isBoolGetterStartWithIs(Method method) {
        return BeanKit.firstWordMatch(method, IS) && BeanKit.isReturningBool(method) && MethodKit.hasNoArg(method);
    }

    public static boolean isStrictSetter(Method method) {
        return BeanKit.isSetter(method, true);
    }

    public static boolean isSetter(Method method, boolean checkReturnType) {
        return BeanKit.firstWordMatch(method, SET) && method.getParameterTypes().length == 1 && (!checkReturnType || method.getReturnType() == Void.TYPE);
    }

    private static boolean firstWordMatch(Method method, String prefix) {
        String methodName = method.getName();
        int prefixLen = prefix.length();
        if (methodName.length() <= prefixLen) {
            return false;
        }
        if (methodName.startsWith(prefix)) {
            return !Character.isLowerCase(methodName.charAt(prefixLen));
        }
        return false;
    }

    private static boolean isReturningBool(Method method) {
        Class<?> returnType = method.getReturnType();
        return returnType == Boolean.TYPE || returnType == Boolean.class;
    }

    public static Method getSetterIgnoreNameCaseAndTypeAssigned(Class<?> clazz, Class<?> fieldClass) {
        return MethodKit.findMethodIgnoreCaseAndArgsTypesAssigned(clazz.getMethods(), BeanKit.toSetterName(fieldClass.getSimpleName()), fieldClass);
    }

    public static Collection<Method> getAllGettersWithoutGetClass(Class<?> clazz) {
        Collection<Method> collection = ALL_GETTERS_WITHOUT_GET_CLASS_CACHE.get(clazz);
        if (collection == null) {
            Method[] methods;
            collection = new ArrayList<Method>();
            for (Method m : methods = clazz.getMethods()) {
                String name = m.getName();
                if (!name.startsWith(GET) || "getClass".equals(name) || name.length() <= GET_LEN || !Character.isUpperCase(name.charAt(GET_LEN)) || m.getParameterTypes().length != 0 || m.getReturnType() == Void.class) continue;
                collection.add(m);
            }
            ALL_GETTERS_WITHOUT_GET_CLASS_CACHE.put(clazz, collection);
        }
        return collection;
    }

    public static Collection<Method> getAllSetters(Class<?> clazz) {
        Collection<Method> collection = ALL_SETTERS_CACHE.get(clazz);
        if (collection == null) {
            Method[] methods = clazz.getMethods();
            collection = new ArrayList<Method>(methods.length);
            for (Method m : methods) {
                String name = m.getName();
                if (!name.startsWith(SET) || name.length() <= SET_LEN || !Character.isUpperCase(name.charAt(SET_LEN)) || m.getParameterTypes().length != 1) continue;
                collection.add(m);
            }
            ALL_SETTERS_CACHE.put(clazz, collection);
        }
        return new ArrayList<Method>(collection);
    }

    public static Collection<Method> getAllSettersForField(Class<?> clazz) throws RuntimeException {
        Collection<Method> setters0 = BeanKit.getAllSetters(clazz);
        if (Kits.COLL.isEmpty(setters0)) {
            return setters0;
        }
        LinkedHashMap setterNameMap = new LinkedHashMap(setters0.size());
        setters0.stream().filter(setter -> BeanKit.isSetter(setter, false)).forEach(setter -> {
            Class<?> fieldClass = setter.getParameterTypes()[0];
            String fieldName = BeanKit.setterNameToFieldName(setter.getName());
            Method setterFromMap = (Method)setterNameMap.get(fieldName);
            if (setterFromMap == null) {
                setterNameMap.put(fieldName, setter);
            } else {
                Class<?> setterArgFromMap = setterFromMap.getParameterTypes()[0];
                if (fieldClass.isAssignableFrom(setterArgFromMap)) {
                    return;
                }
                if (setterArgFromMap.isAssignableFrom(fieldClass)) {
                    setterNameMap.put(fieldName, setter);
                } else {
                    throw new RuntimeException("\u7c7b" + clazz.getSimpleName() + "\u7684" + fieldName + "\u5b57\u6bb5\u6709\u4e24\u4e2asetter\u65b9\u6cd5,\u4f46\u662f\u53c2\u6570\u5374\u53c8\u4e0d\u76f8\u5bb9");
                }
            }
        });
        return new ArrayList<Method>(setterNameMap.values());
    }

    public static Method getGetter(String fieldName, Class<?> c) {
        String getterName = BeanKit.toGetterName(fieldName);
        try {
            return c.getMethod(getterName, new Class[0]);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchThingException("Method", getterName, e);
        }
        return null;
    }
}

