/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang.java;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import me.magicall.support.lang.java.PrimitiveKit;

public final class BoolKit
extends PrimitiveKit<Boolean, boolean[]>
implements Serializable {
    public static final BoolKit INSTANCE = new BoolKit();
    private static final List<Class<?>> SUPPORTED_CLASSES = Arrays.asList(Boolean.class, Boolean.TYPE);
    private static final String[] TRUE_STR = new String[]{Boolean.TRUE.toString()};
    private static final long serialVersionUID = -3005476553700563936L;

    @Override
    public Stream<Class<?>> supportedClasses() {
        return SUPPORTED_CLASSES.stream();
    }

    @Override
    public Stream<String> supportedTypeNames() {
        return Stream.concat(super.supportedTypeNames(), Stream.of("bool"));
    }

    @Override
    public Boolean parse(String source) {
        return Arrays.stream(TRUE_STR).anyMatch(s -> s.equalsIgnoreCase(source));
    }

    @Override
    public <T1, T2> Boolean emptyVal() {
        return Boolean.FALSE;
    }

    @Override
    public String primitiveArrFlag() {
        return "Z";
    }

    private Object readResolve() {
        return INSTANCE;
    }
}

