/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang.java;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import me.magicall.support.lang.java.NotFractionKit;

public final class ByteKit
extends NotFractionKit<Byte, byte[]> {
    private static final long serialVersionUID = -2749786467498972174L;
    private static final List<Class<?>> SUPPORTED_CLASSES = Arrays.asList(Byte.class, Byte.TYPE);
    public static final ByteKit INSTANCE = new ByteKit();

    @Override
    public Stream<Class<?>> supportedClasses() {
        return SUPPORTED_CLASSES.stream();
    }

    @Override
    public Byte parse(String source) {
        try {
            return Byte.parseByte(source);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public String primitiveArrFlag() {
        return "B";
    }

    @Override
    public Byte fromLong(long value) {
        return (byte)value;
    }

    private Object readResolve() {
        return INSTANCE;
    }
}

