/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang.java;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import me.magicall.support.lang.java.PrimitiveKit;

public final class CharKit
extends PrimitiveKit<Character, char[]>
implements Serializable {
    public static final CharKit INSTANCE = new CharKit();
    public static final char NULL = '\u0000';
    public static final char START_HEAD_LINE = '\u0001';
    public static final char START_OF_TEXT = '\u0002';
    public static final char END_OF_TEXT = '\u0003';
    public static final char END_OF_TRANSMISSION = '\u0004';
    public static final char ENQUIRY = '\u0005';
    public static final char ACKNOWLEDGE = '\u0006';
    public static final char BELL = '\u0007';
    public static final char BACKSPACE = '\b';
    public static final char HORIZONTAL_TAB = '\t';
    public static final char NEW_LINE = '\n';
    public static final char LINE_FEED = '\n';
    public static final char VERTICAL_TAB = '\u000b';
    public static final char NEW_PAGE = '\f';
    public static final char FORM_FEED = '\f';
    public static final char CARRIAGE_RETURN = '\r';
    public static final char SHIFT_OUT = '\u000e';
    public static final char SHIFT_IN = '\u000f';
    public static final char DATA_LINK_ESCAPE = '\u0010';
    public static final char DEVICE_CONTROL_1 = '\u0011';
    public static final char DEVICE_CONTROL_2 = '\u0012';
    public static final char DEVICE_CONTROL_3 = '\u0013';
    public static final char DEVICE_CONTROL_4 = '\u0014';
    public static final char NEGATIVE_ACKNOWLEDGE = '\u0015';
    public static final char SYNCHRONOUS_IDLE = '\u0016';
    public static final char END_OF_TRANS_BLOCK = '\u0017';
    public static final char CANCEL = '\u0018';
    public static final char END_OF_MEDIA = '\u0019';
    public static final char SUBSTITUTE = '\u001a';
    public static final char ESCAPE = '\u001b';
    public static final char FILE_SEPARATOR = '\u001c';
    public static final char GROUP_SEPARATOR = '\u001d';
    public static final char RECORD_SEPARATOR = '\u001e';
    public static final char UNIT_SEPARATOR = '\u001f';
    public static final char SPACE = ' ';
    private static final List<Class<?>> SUPPORTED_CLASSES = Arrays.asList(Character.class, Character.TYPE);
    private static final char EMPTY_VALUE = '\u0000';
    private static final int HALF_FULL_SIGN_DELTA = 65248;
    private static final long serialVersionUID = -8786078246893893279L;

    @Override
    public Stream<Class<?>> supportedClasses() {
        return SUPPORTED_CLASSES.stream();
    }

    public boolean equalsIgnoreCase(char c1, char c2) {
        return Character.toLowerCase(c1) == Character.toLowerCase(c2);
    }

    @Override
    public Character parse(String source) {
        return Character.valueOf(source.charAt(0));
    }

    @Override
    public <T1, T2> Character emptyVal() {
        return Character.valueOf('\u0000');
    }

    @Override
    public String primitiveArrFlag() {
        return "C";
    }

    public static char toFullWidth(char c) {
        if (c == ' ') {
            return '\u3000';
        }
        if (c < '\u007f') {
            return (char)(c + 65248);
        }
        return c;
    }

    public static char toHalfWidth(char c) {
        if (c == '\u3000') {
            return ' ';
        }
        if (c > '\uff00' && c < '\uff5f') {
            return (char)(c - 65248);
        }
        return c;
    }

    public static boolean in(char c, char ... arr) {
        for (char c1 : arr) {
            if (c1 != c) continue;
            return true;
        }
        return false;
    }

    public static boolean isEnLetter(char ch) {
        return CharKit.isEnUpperCase(ch) || CharKit.isEnLowerCase(ch);
    }

    public static boolean isEnLetter(int ch) {
        return CharKit.isEnUpperCase(ch) || CharKit.isEnLowerCase(ch);
    }

    public static boolean isEnUpperCase(char ch) {
        return 'A' <= ch && ch <= 'Z';
    }

    public static boolean isEnUpperCase(int ch) {
        return 65 <= ch && ch <= 90;
    }

    public static boolean isEnLowerCase(char ch) {
        return 'a' <= ch && ch <= 'z';
    }

    public static boolean isEnLowerCase(int ch) {
        return 97 <= ch && ch <= 122;
    }

    private Object readResolve() {
        return INSTANCE;
    }
}

