/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang.java;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import me.magicall.support.coll.CollKit;
import me.magicall.support.exception.UnknownException;
import me.magicall.support.exception.WrongArgException;
import me.magicall.support.lang.java.AccessLv;
import me.magicall.support.lang.java.BeanKit;
import me.magicall.support.lang.java.ClassBoundRange;
import me.magicall.support.lang.java.EnhancedClass;
import me.magicall.support.lang.java.EnhancedConstructor;
import me.magicall.support.lang.java.EnhancedField;
import me.magicall.support.lang.java.EnhancedMethod;
import me.magicall.support.lang.java.Kits;
import me.magicall.support.lang.java.MethodKit;
import org.apache.commons.lang3.ClassUtils;

public class ClassKit {
    private static final char ARR_CLASS_START_CHAR = '[';
    private static final char OBJ_ARR_FLAG_CHAR = 'L';
    private static final char OBJ_ARR_CLASS_END_CHAR = ';';
    private static final Range<Integer> AVAILABLE_DIM_RANGE = Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(Integer.MAX_VALUE));
    public static final String FILE_SUFFIX = ".class";
    public static final int FILE_SUFFIX_LEN = ".class".length();

    public static <T> EnhancedClass<T> enhance(Class<T> c) {
        return EnhancedClass.of(c);
    }

    public static EnhancedMethod enhance(Method method) {
        return EnhancedMethod.of(method);
    }

    public static EnhancedField enhance(Field field) {
        return EnhancedField.of(field);
    }

    public static <T> EnhancedConstructor<T> enhance(Constructor<T> constructor) {
        return EnhancedConstructor.of(constructor);
    }

    public static AccessLv accessLvOf(int modifierFlag) {
        return AccessLv.of(modifierFlag);
    }

    public static AccessLv accessLvOf(Class<?> c) {
        return c == null ? null : AccessLv.of(c.getModifiers());
    }

    public static AccessLv accessLvOf(Member member) {
        return member == null ? null : AccessLv.of(member.getModifiers());
    }

    public static boolean isPublic(int modifierFlag) {
        return ClassKit.accessLvOf(modifierFlag) == AccessLv.PUBLIC;
    }

    public static boolean isPublic(Class<?> c) {
        return c != null && ClassKit.isPublic(c.getModifiers());
    }

    public static boolean isPublic(Member member) {
        return member != null && ClassKit.isPublic(member.getModifiers());
    }

    public static boolean isDefaultAccess(int modifierFlag) {
        return ClassKit.accessLvOf(modifierFlag) == AccessLv.DEFAULT;
    }

    public static boolean isDefaultAccess(Class<?> c) {
        return c != null && ClassKit.isDefaultAccess(c.getModifiers());
    }

    public static boolean isDefaultAccess(Member member) {
        return member != null && ClassKit.isDefaultAccess(member.getModifiers());
    }

    public static boolean isProtected(int modifierFlag) {
        return ClassKit.accessLvOf(modifierFlag) == AccessLv.PROTECTED;
    }

    public static boolean isProtected(Class<?> c) {
        return c != null && ClassKit.isProtected(c.getModifiers());
    }

    public static boolean isProtected(Member member) {
        return member != null && ClassKit.isProtected(member.getModifiers());
    }

    public static boolean isPrivate(int modifierFlag) {
        return ClassKit.accessLvOf(modifierFlag) == AccessLv.PRIVATE;
    }

    public static boolean isPrivate(Class<?> c) {
        return c != null && ClassKit.isPrivate(c.getModifiers());
    }

    public static boolean isPrivate(Member member) {
        return member != null && ClassKit.isPrivate(member.getModifiers());
    }

    public static boolean isStatic(int modifierFlag) {
        return Modifier.isStatic(modifierFlag);
    }

    public static boolean isStatic(Class<?> c) {
        return c != null && ClassKit.isStrict(c.getModifiers());
    }

    public static boolean isStatic(Member member) {
        return member != null && ClassKit.isStrict(member.getModifiers());
    }

    public static boolean isFinal(int modifierFlag) {
        return Modifier.isFinal(modifierFlag);
    }

    public static boolean isFinal(Class<?> c) {
        return c != null && ClassKit.isFinal(c.getModifiers());
    }

    public static boolean isFinal(Member member) {
        return member != null && ClassKit.isFinal(member.getModifiers());
    }

    public static boolean isStrict(int modifierFlag) {
        return Modifier.isStrict(modifierFlag);
    }

    public static boolean isStrict(Class<?> c) {
        return c != null && ClassKit.isStrict(c.getModifiers());
    }

    public static boolean isStrict(Member member) {
        return member != null && ClassKit.isStrict(member.getModifiers());
    }

    public static boolean isVolatile(int modifierFlag) {
        return Modifier.isVolatile(modifierFlag);
    }

    public static boolean isVolatile(Field field) {
        return Modifier.isVolatile(field.getModifiers());
    }

    public static boolean isAbstract(int modifierFlag) {
        return Modifier.isAbstract(modifierFlag);
    }

    public static boolean isAbstract(Class<?> c) {
        return c != null && ClassKit.isAbstract(c.getModifiers());
    }

    public static boolean isAbstract(Method method) {
        return method != null && ClassKit.isAbstract(method.getModifiers());
    }

    public static boolean isTransient(int modifierFlag) {
        return Modifier.isTransient(modifierFlag);
    }

    public static boolean isTransient(Field f) {
        return f != null && ClassKit.isTransient(f.getModifiers());
    }

    public static boolean isNative(int modifierFlag) {
        return Modifier.isNative(modifierFlag);
    }

    public static boolean isNative(Method method) {
        return method != null && ClassKit.isNative(method.getModifiers());
    }

    public static boolean isVarArgs(Method method) {
        return method.isVarArgs();
    }

    public static boolean isVarArgs(Constructor<?> constructor) {
        return constructor.isVarArgs();
    }

    public static Class<?> classCalled(String fullName) {
        try {
            return Class.forName(fullName);
        }
        catch (ClassNotFoundException ignored) {
            return null;
        }
    }

    public static boolean isExactClass(Class<?> c) {
        return c != null && !c.isInterface() && !c.isAnnotation() && !c.isEnum();
    }

    public static boolean isExtendable(Class<?> c) {
        return c != null && !ClassKit.isFinal(c);
    }

    public static boolean isAnonymous(Class<?> c) {
        return c != null && c.isAnonymousClass();
    }

    public static boolean isInner(Class<?> c) {
        return c != null && c.isMemberClass();
    }

    public static boolean isMultiVal(Class<?> c) {
        if (c == null) {
            return false;
        }
        return ClassKit.isOrSubOf(c, Iterable.class) || ClassKit.isOrSubOf(c, Map.class) || ClassKit.isOrSubOf(c, Stream.class) || ClassKit.isArr(c) || ClassKit.isEnum(c) || ClassKit.isOrSubOf(c, Iterator.class) || ClassKit.isOrSubOf(c, Enumeration.class);
    }

    public static boolean isInterface(Class<?> c) {
        return c != null && c.isInterface();
    }

    public static boolean isPrimitive(Class<?> c) {
        return c != null && c.isPrimitive();
    }

    public static boolean isNum(Class<?> c) {
        return c != null && (ClassKit.isPrimitiveNum(c) || ClassKit.isOrSubOf(c, Number.class));
    }

    public static boolean isPrimitiveNum(Class<?> c) {
        return ClassKit.isPrimitive(c) && c != Character.TYPE && c != Boolean.TYPE;
    }

    public static boolean isByte(Class<?> c) {
        return c == Byte.TYPE || c == Byte.class;
    }

    public static boolean isShort(Class<?> c) {
        return c == Short.TYPE || c == Short.class;
    }

    public static boolean isInt(Class<?> c) {
        return c == Integer.TYPE || c == Integer.class;
    }

    public static boolean isLong(Class<?> c) {
        return c == Long.TYPE || c == Long.class;
    }

    public static boolean isFloat(Class<?> c) {
        return c == Float.TYPE || c == Float.class;
    }

    public static boolean isDouble(Class<?> c) {
        return c == Double.TYPE || c == Double.class;
    }

    public static boolean hasFraction(Class<?> c) {
        return c != null && (ClassKit.isFloat(c) || ClassKit.isDouble(c) || ClassKit.isOrSubOf(c, BigDecimal.class));
    }

    public static boolean isBool(Class<?> c) {
        return c == Boolean.TYPE || c == Boolean.class;
    }

    public static boolean isChar(Class<?> c) {
        return c == Character.TYPE || c == Character.class;
    }

    public static boolean isText(Class<?> c) {
        return ClassKit.isOrSubOf(c, CharSequence.class);
    }

    public static boolean isStr(Class<?> c) {
        return c == String.class;
    }

    public static boolean isAboutTime(Class<?> c) {
        return c != null && Stream.of(Date.class, Calendar.class, Temporal.class, TemporalAmount.class).anyMatch(e -> ClassKit.isOrSubOf(c, e));
    }

    public static boolean isDate(Class<?> c) {
        return ClassKit.isOrSubOf(c, Date.class);
    }

    public static boolean isObj(Class<?> c) {
        return c == Object.class;
    }

    public static boolean isArr(Class<?> c) {
        return c != null && c.isArray();
    }

    public static boolean isEnum(Class<?> c) {
        return c != null && c.isEnum();
    }

    public static boolean isEnumLike(Class<?> c) {
        return ClassKit.isEnum(c);
    }

    public static boolean isAnnotation(Class<?> c) {
        return c != null && c.isAnnotation();
    }

    public static <T> Class<? super T> parentOf(Class<T> c) {
        return c == null ? null : c.getSuperclass();
    }

    public static boolean isOrSubOf(Class<?> maybeProgeny, Class<?> maybeAncestor) {
        return maybeAncestor != null && maybeProgeny != null && maybeAncestor.isAssignableFrom(maybeProgeny);
    }

    public static boolean isOrSuperOf(Class<?> maybeAncestor, Class<?> maybeProgeny) {
        return maybeAncestor != null && maybeProgeny != null && maybeAncestor.isAssignableFrom(maybeProgeny);
    }

    public static Stream<Class<?>> superClassesOf(Class<?> c) {
        return Stream.iterate(ClassKit.parentOf(c), Objects::nonNull, Class::getSuperclass);
    }

    public static Stream<Class<?>> interfacesOf(Class<?> c) {
        if (c == null) {
            return Stream.empty();
        }
        return ClassKit.superClassesOf(c).flatMap(e -> Stream.of(e.getInterfaces())).distinct();
    }

    public static boolean hasInterface(Class<?> c) {
        return ClassKit.interfacesOf(c).findAny().isPresent();
    }

    public static Stream<Class<?>> ancestorsOf(Class<?> c) {
        return c == null ? Stream.empty() : CollKit.concat(ClassKit.superClassesOf(c), ClassKit.interfacesOf(c));
    }

    public static Stream<Class<?>> directParents(Class<?> c) {
        return c == null ? Stream.empty() : CollKit.concat(Stream.of(c.getSuperclass()), Stream.of(c.getInterfaces()));
    }

    public static Class<?> owner(Class<?> c) {
        if (c == null) {
            return null;
        }
        Class<?> declaringClass = c.getDeclaringClass();
        if (declaringClass != null) {
            return declaringClass;
        }
        return c.getEnclosingClass();
    }

    public static Stream<Class<?>> memberClasses(Class<?> c) {
        return c == null ? Stream.empty() : Stream.of(c.getDeclaredClasses());
    }

    public static Class<?>[] toClasses(Object ... objs) {
        return ClassUtils.toClass((Object[])objs);
    }

    public static boolean checkAllAssignable(Class<?>[] superClasses, Object ... objects) {
        return ClassKit.checkAllAssignable(superClasses, ClassKit.toClasses(objects));
    }

    public static boolean checkAllAssignable(Class<?>[] superClasses, Class<?> ... subClasses) {
        if (superClasses.length != subClasses.length) {
            return false;
        }
        int index = 0;
        for (Class<?> c : superClasses) {
            if (!c.isAssignableFrom(subClasses[index])) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static Class<?> arrClass(String componentTypeName, int dim) {
        if (dim < 1) {
            throw new WrongArgException("dim", (Object)dim, AVAILABLE_DIM_RANGE);
        }
        String sb = IntStream.iterate(dim, i -> i > 0, i -> i - 1).mapToObj(i -> String.valueOf('[')).collect(Collectors.joining("", "", componentTypeName));
        return ClassKit.classCalled(sb);
    }

    public static Class<?> arrClass(Class<?> clazz, int dim) {
        if (dim < 1) {
            throw new WrongArgException("dim", (Object)dim, AVAILABLE_DIM_RANGE);
        }
        int factDim = clazz.isArray() ? dim + ClassKit.dimOfArrayClass(clazz) : dim;
        Class<?> componentType = ClassKit.componentType(clazz);
        return ClassKit.arrClass((String)(componentType.isPrimitive() ? Kits.getPrimitiveKit(componentType).primitiveArrFlag() : "L" + componentType.getName() + ";"), factDim);
    }

    public static Class<?> componentType(Class<?> arrClass) {
        Class<?> c = arrClass;
        while (c.isArray()) {
            c = c.getComponentType();
        }
        return c;
    }

    public static int dimOfArrayClass(Class<?> arrClass) {
        return Kits.CHAR.frequency(Character.valueOf('['), arrClass.getName().toCharArray());
    }

    public static <T> Stream<Constructor<T>> constructorsOf(Class<T> c) {
        return c == null ? Stream.empty() : Stream.of(c.getDeclaredConstructors());
    }

    public static <T> Constructor<T> constructorOf(Class<T> c, Class<?> ... argTypes) {
        Constructor<T> constructor = ClassKit.constructorStrictFitArgs(c, argTypes);
        return constructor == null ? ClassKit.findCompatibleConstructor(c, argTypes) : constructor;
    }

    public static <T> Constructor<T> findCompatibleConstructor(Class<T> clazz, Class<?> ... argTypes) {
        Constructor<?>[] constructors = clazz.getConstructors();
        Constructor<?> c = null;
        for (Constructor<?> constructor : constructors) {
            Object[] parametersTypes = constructor.getParameterTypes();
            if (parametersTypes.length != argTypes.length) continue;
            if (Arrays.equals(parametersTypes, argTypes)) {
                return constructor;
            }
            if (!ClassKit.checkAllAssignable(parametersTypes, argTypes)) continue;
            c = constructor;
        }
        return c;
    }

    public static <T> Constructor<T> constructorStrictFitArgs(Class<T> clazz, Class<?> ... argTypes) {
        try {
            return clazz.getConstructor(argTypes);
        }
        catch (NoSuchMethodException ignored) {
            return null;
        }
        catch (SecurityException e) {
            throw new UnknownException(e);
        }
    }

    public static boolean canNewInstance(Class<?> c) {
        return ClassKit.isExactClass(c) && !Modifier.isAbstract(c.getModifiers());
    }

    public static <T> T newInstance(ClassLoader classLoader, String className, Object ... constructorArgs) {
        try {
            return (T)ClassKit.newInstance(Class.forName(className, true, classLoader), constructorArgs);
        }
        catch (ClassNotFoundException ignored) {
            return null;
        }
    }

    public static <T> T newInstance(String className, Object ... constructorArgs) {
        try {
            return (T)ClassKit.newInstance(Class.forName(className), constructorArgs);
        }
        catch (ClassNotFoundException ignored) {
            return null;
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... params) {
        Constructor<T> constructor = ClassKit.constructorOf(clazz, ClassKit.toClasses(params));
        if (constructor != null) {
            try {
                return constructor.newInstance(params);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static int countGenericTypes(Class<?> c) {
        return c == null ? 0 : 0;
    }

    public static boolean hasGenericTypes(Class<?> c) {
        return c != null && c.toGenericString().contains("<");
    }

    public static boolean isImplementingGenericTypes(Class<?> c) {
        return ClassKit.directParents(c).anyMatch(ClassKit::hasGenericTypes);
    }

    public static ListMultimap<Class<?>, Class<?>> implementedGenericTypes(Class<?> clazz) {
        LinkedHashMap genericTypes = Maps.newLinkedHashMap();
        ClassKit.addImplementedGenericTypes(clazz, genericTypes);
        ArrayListMultimap rt = ArrayListMultimap.create();
        genericTypes.forEach((arg_0, arg_1) -> ClassKit.lambda$implementedGenericTypes$5((ListMultimap)rt, arg_0, arg_1));
        return rt;
    }

    public static Stream<ClassBoundRange> genericTypes(Class<?> c) {
        return null;
    }

    private static void addImplementedGenericTypes(Class<?> clazz, Map<Class<?>, Map<String, Class<?>>> rt) {
        Type[] parentInterfaces = clazz.getGenericInterfaces();
        Arrays.stream(parentInterfaces).forEach(parentInterfaceType -> ClassKit.addSuperInterfaceImplementedGenericTypes(clazz, parentInterfaceType, rt));
    }

    private static void addSuperInterfaceImplementedGenericTypes(Class<?> clazz, Type parentInterfaceType, Map<Class<?>, Map<String, Class<?>>> rt) {
        Class parentInterfaceClass;
        if (parentInterfaceType instanceof ParameterizedType) {
            ParameterizedType paramedParentInterface = (ParameterizedType)parentInterfaceType;
            ClassKit.handleTransitivity(clazz, paramedParentInterface, rt);
            parentInterfaceClass = (Class)paramedParentInterface.getRawType();
        } else {
            parentInterfaceClass = (Class)parentInterfaceType;
        }
        ClassKit.addImplementedGenericTypes(parentInterfaceClass, rt);
    }

    private static void handleTransitivity(Class<?> clazz, ParameterizedType paramedParentInterface, Map<Class<?>, Map<String, Class<?>>> rt) {
        Type[] actualTypeArgs = paramedParentInterface.getActualTypeArguments();
        Class parentClass = (Class)paramedParentInterface.getRawType();
        TypeVariable<Class<T>>[] parentTypeParams = parentClass.getTypeParameters();
        assert (parentTypeParams.length == actualTypeArgs.length);
        int i = 0;
        for (TypeVariable typeParam : parentTypeParams) {
            String parentGenericParamName = typeParam.getName();
            Type actualTypeArg = actualTypeArgs[i];
            if (actualTypeArg instanceof TypeVariable) {
                Class<?> actualType = ClassKit.genericParamActualClassFromChild(rt, clazz, (TypeVariable)actualTypeArg);
                if (actualType != null) {
                    ClassKit.checkAndPut(rt, parentClass, parentGenericParamName, actualType);
                }
            } else {
                ClassKit.checkAndPut(rt, parentClass, parentGenericParamName, (Class)actualTypeArg);
            }
            ++i;
        }
    }

    private static Class<?> genericParamActualClassFromChild(Map<Class<?>, Map<String, Class<?>>> rt, Class<?> clazz, TypeVariable<?> variableType) {
        String childGenericParamName = variableType.getName();
        Map<String, Class<?>> genericMapping = rt.get(clazz);
        return genericMapping == null ? null : genericMapping.get(childGenericParamName);
    }

    private static void checkAndPut(Map<Class<?>, Map<String, Class<?>>> rt, Class<?> paramedParentRawType, String genericParamName, Class<?> actualType) {
        rt.computeIfAbsent(paramedParentRawType, k -> Maps.newLinkedHashMap()).put(genericParamName, actualType);
    }

    public static Stream<Field> fieldsOf(Class<?> c) {
        return c == null ? Stream.empty() : CollKit.concat(Stream.of(c.getDeclaredFields()), ClassKit.fieldsOf(ClassKit.parentOf(c)), ClassKit.interfacesOf(c).flatMap(ClassKit::fieldsOf)).distinct();
    }

    public static boolean hasFields(Class<?> c) {
        return ClassKit.fieldsOf(c).findAny().isPresent();
    }

    public static Stream<Field> ownFieldsOf(Class<?> c) {
        return c == null ? Stream.empty() : Stream.of(c.getDeclaredFields());
    }

    public static boolean hasOwnFields(Class<?> c) {
        return ClassKit.ownFieldsOf(c).findAny().isPresent();
    }

    public static Field fieldCalled(Class<?> c, String name) {
        if (Kits.STR.isEmpty(name)) {
            return null;
        }
        return ClassKit.fieldsOf(c).filter(e -> e.getName().equals(name)).findFirst().orElse(null);
    }

    public static boolean hasFieldCalled(Class<?> c, String name) {
        return ClassKit.fieldCalled(c, name) != null;
    }

    public static Field fieldOf(Class<?> c, String name, Class<?> type) {
        if (type == null) {
            return null;
        }
        Field field = ClassKit.fieldCalled(c, name);
        return field != null && type == field.getType() ? field : null;
    }

    public static boolean hasField(Class<?> c, String name, Class<?> type) {
        return ClassKit.fieldOf(c, name, type) != null;
    }

    public static void callSetter(Object target, Object fieldValue) {
        Class<?> fieldClass = fieldValue.getClass();
        Class<?> objClass = target.getClass();
        Method setter = BeanKit.getSetterIgnoreNameCaseAndTypeAssigned(objClass, fieldClass);
        if (setter != null) {
            MethodKit.invoke(target, setter, fieldValue);
        }
    }

    public static <T> T valOf(Object target, Field field) {
        try {
            field.setAccessible(true);
            return (T)field.get(target);
        }
        catch (IllegalAccessException e) {
            throw new UnknownException(e);
        }
    }

    public static Stream<Method> methodsOf(Class<?> c) {
        return c == null ? Stream.empty() : CollKit.concat(ClassKit.ownMethodsOf(c), ClassKit.methodsOf(ClassKit.parentOf(c)), ClassKit.interfacesOf(c).flatMap(ClassKit::methodsOf)).distinct();
    }

    public static boolean hasMethods(Class<?> c) {
        return ClassKit.methodsOf(c).findAny().isPresent();
    }

    public static Stream<Method> ownMethodsOf(Class<?> c) {
        return c == null ? Stream.empty() : Stream.of(c.getDeclaredMethods());
    }

    public static boolean hasOwnMethods(Class<?> c) {
        return ClassKit.ownMethodsOf(c).findAny().isPresent();
    }

    public static Stream<Method> instanceMethods(Class<?> c) {
        return ClassKit.methodsOf(c).filter(e -> !ClassKit.isStatic(e));
    }

    public static Stream<Method> staticMethods(Class<?> c) {
        return ClassKit.methodsOf(c).filter(ClassKit::isStatic);
    }

    public static Method methodOf(Class<?> c, String name, Class<?> ... paramTypes) {
        if (c == null || Kits.STR.isEmpty(name)) {
            return null;
        }
        return ClassKit.methodsOf(c).filter(e -> e.getName().equals(name) && ClassKit.checkAllAssignable(e.getParameterTypes(), paramTypes)).findFirst().orElse(null);
    }

    public static boolean hasMethod(Class<?> c, String name, Class<?> ... paramTypes) {
        return ClassKit.methodOf(c, name, paramTypes) != null;
    }

    public static Method methodStrictFitArgs(Class<?> c, String name, Class<?> ... paramTypes) {
        if (c == null || Kits.STR.isEmpty(name)) {
            return null;
        }
        return ClassKit.methodsOf(c).filter(e -> e.getName().equals(name) && Arrays.equals(e.getParameterTypes(), paramTypes)).findFirst().orElse(null);
    }

    private static /* synthetic */ void lambda$implementedGenericTypes$5(ListMultimap rt, Class k, Map v) {
        rt.putAll((Object)k, v.values());
    }
}

