/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang.java;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import me.magicall.support.lang.java.NumKit;

public final class DoubleKit
extends NumKit<Double, double[]>
implements Serializable {
    private static final long serialVersionUID = -4630271293077726296L;
    private static final List<Class<?>> SUPPORTED_CLASSES = Arrays.asList(Double.class, Double.TYPE);
    public static final DoubleKit INSTANCE = new DoubleKit();
    private static final double EMPTY_VALUE = 0.0;

    @Override
    public Stream<Class<?>> supportedClasses() {
        return SUPPORTED_CLASSES.stream();
    }

    @Override
    public Double parse(String source) {
        try {
            return Double.parseDouble(source);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public <T1, T2> Double emptyVal() {
        return 0.0;
    }

    @Override
    protected double[] newPrimitiveArr(int size) {
        return new double[size];
    }

    @Override
    public String primitiveArrFlag() {
        return "D";
    }

    @Override
    public Double fromLong(long value) {
        return value;
    }

    private Object readResolve() {
        return INSTANCE;
    }
}

