/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang.java;

import java.lang.reflect.Field;
import java.util.stream.Stream;
import me.magicall.support.lang.java.AccessLv;
import me.magicall.support.lang.java.ClassBoundRange;
import me.magicall.support.lang.java.ClassKit;
import me.magicall.support.lang.java.ClassMember;
import me.magicall.support.lang.java.EnhancedClassImpl;
import me.magicall.support.lang.java.EnhancedConstructor;
import me.magicall.support.lang.java.EnhancedField;
import me.magicall.support.lang.java.EnhancedMethod;
import me.magicall.support.lang.java.PackageKit;

public interface EnhancedClass<T>
extends ClassMember<Class<T>> {
    @Override
    default public boolean isNull() {
        return this.toClass() == null;
    }

    @Override
    default public Class<T> unwrap() {
        return this.toClass();
    }

    public Class<T> toClass();

    @Override
    public String name();

    @Override
    public String shortName();

    @Override
    default public Package pack() {
        return PackageKit.packageOf(this.toClass());
    }

    @Override
    default public EnhancedClass<?> owner() {
        return EnhancedClass.of(ClassKit.owner(this.toClass()));
    }

    @Override
    default public AccessLv accessLv() {
        return ClassKit.accessLvOf(this.toClass());
    }

    @Override
    default public boolean isFinal() {
        return ClassKit.isFinal(this.toClass());
    }

    @Override
    default public boolean isStatic() {
        return ClassKit.isStatic(this.toClass());
    }

    default public boolean isMultiVal() {
        return ClassKit.isMultiVal(this.toClass());
    }

    default public boolean isArr() {
        return ClassKit.isArr(this.toClass());
    }

    default public boolean isInterface() {
        return ClassKit.isInterface(this.toClass());
    }

    default public boolean isEnum() {
        return ClassKit.isEnum(this.toClass());
    }

    default public boolean isAnnotation() {
        return ClassKit.isAnnotation(this.toClass());
    }

    default public boolean is(Class<?> other) {
        return this.isOrSubOf(other);
    }

    default public boolean isOrSubOf(Class<?> maybeMeOrAncestor) {
        return ClassKit.isOrSubOf(this.toClass(), maybeMeOrAncestor);
    }

    default public boolean isOrSuperOf(Class<?> maybeMeOrProgeny) {
        return ClassKit.isOrSuperOf(this.toClass(), maybeMeOrProgeny);
    }

    default public Stream<EnhancedClass<?>> ancestors() {
        return ClassKit.ancestorsOf(this.toClass()).map(EnhancedClass::of);
    }

    default public Stream<EnhancedClass<?>> directParents() {
        return ClassKit.directParents(this.toClass()).map(EnhancedClass::of);
    }

    default public boolean isNum() {
        return ClassKit.isNum(this.toClass());
    }

    default public boolean isText() {
        return ClassKit.isText(this.toClass());
    }

    default public boolean isBool() {
        return ClassKit.isBool(this.toClass());
    }

    default public boolean isAboutTime() {
        return ClassKit.isAboutTime(this.toClass());
    }

    default public Stream<EnhancedConstructor<T>> constructors() {
        return ClassKit.constructorsOf(this.toClass()).map(EnhancedConstructor::of);
    }

    default public Stream<EnhancedConstructor<T>> constructors(AccessLv accessLv) {
        return this.constructors().filter(e -> e.is(accessLv));
    }

    default public Stream<EnhancedMethod> methods() {
        return ClassKit.methodsOf(this.toClass()).map(EnhancedMethod::of);
    }

    default public Stream<EnhancedMethod> myOwnMethods() {
        return ClassKit.ownMethodsOf(this.toClass()).map(EnhancedMethod::of);
    }

    default public EnhancedMethod methodOf(String name, Class<?> ... paramTypes) {
        return EnhancedMethod.of(ClassKit.methodOf(this.toClass(), name, paramTypes));
    }

    default public boolean hasMethod(String name, Class<?> ... paramTypes) {
        return ClassKit.hasMethod(this.toClass(), name, paramTypes);
    }

    default public Stream<EnhancedField> fields() {
        return ClassKit.fieldsOf(this.toClass()).map(EnhancedField::of);
    }

    default public boolean hasFields() {
        return ClassKit.hasFields(this.toClass());
    }

    default public Stream<EnhancedField> myOwnFields() {
        return ClassKit.ownFieldsOf(this.toClass()).map(EnhancedField::of);
    }

    default public EnhancedField field(String fieldName) {
        Field field = ClassKit.fieldCalled(this.toClass(), fieldName);
        return EnhancedField.of(field);
    }

    default public boolean hasField(String fieldName) {
        return ClassKit.hasFieldCalled(this.toClass(), fieldName);
    }

    default public boolean isPrototype(Object obj) {
        return this.exists() && this.getClass().isInstance(obj);
    }

    default public boolean canNewInstance() {
        return this.exists() && ClassKit.canNewInstance(this.toClass());
    }

    default public T newOne(Object ... args) {
        return ClassKit.newInstance(this.toClass(), args);
    }

    default public int countGenericTypes() {
        return ClassKit.countGenericTypes(this.toClass());
    }

    default public boolean hasGenericTypes() {
        return ClassKit.hasGenericTypes(this.toClass());
    }

    default public boolean isImplementingGenericTypes() {
        return ClassKit.isImplementingGenericTypes(this.toClass());
    }

    default public Stream<ClassBoundRange> genericTypes() {
        return ClassKit.genericTypes(this.toClass());
    }

    public static <T> EnhancedClass<T> of(Class<?> clazz) {
        return clazz == null ? null : EnhancedClassImpl.of(clazz);
    }

    public static EnhancedClass<?> of(String fullName) {
        return fullName == null ? null : EnhancedClassImpl.of(fullName);
    }

    public static EnhancedClass<Void> ofNull() {
        return EnhancedClassImpl.ofNull();
    }
}

