/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang.java;

import java.util.stream.Stream;
import me.magicall.support.lang.java.ClassKit;
import me.magicall.support.lang.java.EnhancedClass;
import me.magicall.support.lang.java.StrKit;

public class EnhancedClassImpl<T>
implements EnhancedClass<T> {
    private static final EnhancedClassImpl<Void> VOID_ENHANCED_CLASS = new EnhancedClassImpl<Void>(Void.class);
    private final Class<T> raw;
    private final String fullName;
    private final String shortName;

    private EnhancedClassImpl(String fullName) {
        String s = fullName.strip();
        this.raw = ClassKit.classCalled(s);
        this.fullName = s;
        this.shortName = StrKit.subStringAfterLastSeq(s, ".");
    }

    private EnhancedClassImpl(Class<T> raw) {
        this.raw = raw;
        if (raw == null) {
            this.fullName = "null";
            this.shortName = "null";
        } else {
            this.fullName = raw.getName();
            this.shortName = raw.getSimpleName();
        }
    }

    @Override
    public String name() {
        return this.fullName;
    }

    @Override
    public String shortName() {
        return this.shortName;
    }

    public int modifierFlag() {
        return this.exists() ? this.raw.getModifiers() : 0;
    }

    public boolean isExactClass() {
        return ClassKit.isExactClass(this.raw);
    }

    public boolean isExtendable() {
        return ClassKit.isExtendable(this.toClass());
    }

    public boolean isStrict() {
        return ClassKit.isStrict(this.toClass());
    }

    public boolean isAnonymous() {
        return ClassKit.isAnonymous(this.toClass());
    }

    public boolean isInner() {
        return ClassKit.isInner(this.toClass());
    }

    public EnhancedClassImpl<? super T> parent() {
        Class<T> parent = ClassKit.parentOf(this.toClass());
        return parent == null ? null : EnhancedClassImpl.of(parent);
    }

    public Stream<? extends EnhancedClass<? super T>> superClasses() {
        return ClassKit.superClassesOf(this.toClass()).map(EnhancedClass::of);
    }

    public Stream<EnhancedClass<? super T>> interfaces() {
        return ClassKit.interfacesOf(this.toClass()).map(EnhancedClass::of);
    }

    public boolean hasInterfaces() {
        return ClassKit.hasInterface(this.toClass());
    }

    @Override
    public Class<T> toClass() {
        return this.raw;
    }

    public int hashCode() {
        return this.exists() ? this.raw.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        return this.exists() && this.raw.equals(obj);
    }

    public String toString() {
        return this.fullName;
    }

    static <T> EnhancedClassImpl<T> of(Class<?> clazz) {
        return new EnhancedClassImpl(clazz);
    }

    static EnhancedClassImpl<?> of(String fullName) {
        return new EnhancedClassImpl(fullName);
    }

    static EnhancedClassImpl<Void> ofNull() {
        return VOID_ENHANCED_CLASS;
    }
}

