/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang.java;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import me.magicall.support.exception.UnknownException;
import me.magicall.support.lang.java.AccessLv;
import me.magicall.support.lang.java.ClassKit;
import me.magicall.support.lang.java.ClassMember;
import me.magicall.support.lang.java.EnhancedClass;
import me.magicall.support.lang.java.EnhancedConstructor;
import me.magicall.support.lang.java.EnhancedField;
import me.magicall.support.lang.java.EnhancedMethod;

public abstract class EnhancedClassMember<T extends AccessibleObject>
implements ClassMember<T> {
    private final T raw;

    EnhancedClassMember(T raw) {
        this.raw = raw;
    }

    @Override
    public boolean isNull() {
        return this.raw == null;
    }

    @Override
    public T unwrap() {
        return this.raw;
    }

    @Override
    public String name() {
        return ((Member)this.unwrap()).getName();
    }

    @Override
    public EnhancedClass<?> owner() {
        return EnhancedClass.of(((Member)this.unwrap()).getDeclaringClass());
    }

    public abstract EnhancedClass<?> type();

    @Override
    public AccessLv accessLv() {
        return ClassKit.accessLvOf((Member)this.unwrap());
    }

    @Override
    public boolean isFinal() {
        return ClassKit.isFinal((Member)this.unwrap());
    }

    @Override
    public boolean isStatic() {
        return ClassKit.isStatic((Member)this.unwrap());
    }

    public int modifierFlag() {
        return ((Member)this.unwrap()).getModifiers();
    }

    public EnhancedClassMember<T> setNotFinal() {
        if (this.isFinal()) {
            this.removeModifiers(16);
        }
        return this;
    }

    public EnhancedClassMember<T> setFinal() {
        if (!this.isFinal()) {
            this.addModifiers(16);
        }
        return this;
    }

    private EnhancedClassMember<T> removeModifiers(int newModifiers) {
        return this.changeModifier(((Member)this.unwrap()).getModifiers() & ~newModifiers);
    }

    private EnhancedClassMember<T> addModifiers(int newModifiers) {
        return this.changeModifier(((Member)this.unwrap()).getModifiers() | newModifiers);
    }

    private EnhancedClassMember<T> changeModifier(int newModifiers) {
        Object raw = this.unwrap();
        try {
            Field modifiersField = raw.getClass().getDeclaredField("modifiers");
            EnhancedField enhancedModifiersField = EnhancedField.of(modifiersField);
            enhancedModifiersField.setAccessible();
            modifiersField.setInt(raw, newModifiers);
        }
        catch (NoSuchFieldException modifiersField) {
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new UnknownException(e);
        }
        return this;
    }

    public EnhancedClassMember<T> setAccessible() {
        Object raw = this.unwrap();
        Object accessibleObject = raw;
        if (!((AccessibleObject)accessibleObject).isAccessible()) {
            this.setNotFinal();
            ((AccessibleObject)accessibleObject).setAccessible(true);
        }
        return this;
    }

    public EnhancedClassMember<T> setNotAccessible() {
        Object raw = this.unwrap();
        Object accessibleObject = raw;
        if (((AccessibleObject)accessibleObject).isAccessible()) {
            this.setNotFinal();
            ((AccessibleObject)accessibleObject).setAccessible(false);
        }
        return this;
    }

    public <V> V getValFrom(Object ... obj) {
        Object raw = this.unwrap();
        if (raw instanceof Constructor) {
            ((AccessibleObject)raw).setAccessible(true);
            try {
                return (V)((Constructor)raw).newInstance(obj);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new UnknownException(e);
            }
        }
        if (raw instanceof Method) {
            ((AccessibleObject)raw).setAccessible(true);
            try {
                Method method = (Method)raw;
                if (this.isStatic()) {
                    return (V)method.invoke(null, obj);
                }
                if (obj.length == 0) {
                    throw new UnknownException();
                }
                if (obj.length == 1) {
                    return (V)method.invoke(obj[0], new Object[0]);
                }
                return (V)method.invoke(obj[0], obj[1]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new UnknownException(e);
            }
        }
        if (raw instanceof Field) {
            ((AccessibleObject)raw).setAccessible(true);
            try {
                Field field = (Field)raw;
                if (this.isStatic()) {
                    return (V)field.get(null);
                }
                if (obj.length == 0) {
                    throw new UnknownException();
                }
                return (V)field.get(obj[0]);
            }
            catch (IllegalAccessException e) {
                throw new UnknownException(e);
            }
        }
        throw new UnknownException();
    }

    public static EnhancedClassMember<Field> of(Field field) {
        return EnhancedField.of(field);
    }

    public static EnhancedClassMember<Method> of(Method method) {
        return EnhancedMethod.of(method);
    }

    public static <T> EnhancedClassMember<Constructor<T>> of(Constructor<T> constructor) {
        return EnhancedConstructor.of(constructor);
    }
}

