/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang.java;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import me.magicall.support.lang.java.ClassKit;
import me.magicall.support.lang.java.EnhancedClass;
import me.magicall.support.lang.java.EnhancedMethod;
import me.magicall.support.relation.Wrapper;

public class EnhancedObj<T>
implements Wrapper<T> {
    private final T raw;
    private final boolean isPrimitive;

    private EnhancedObj(T raw) {
        this(raw, false);
    }

    private EnhancedObj(T raw, boolean isPrimitive) {
        this.raw = raw;
        this.isPrimitive = isPrimitive;
    }

    public boolean isNull() {
        return this.raw == null;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public boolean is(Class<?> clazz) {
        return !this.isNull() && clazz.isInstance(this.raw);
    }

    public boolean is(EnhancedClass<?> type) {
        return type.exists() && this.is(type.toClass());
    }

    public boolean isNum() {
        return this.raw instanceof Number;
    }

    public boolean isEnum() {
        return this.raw instanceof Enum;
    }

    public boolean isMultiVal() {
        return this.isIterable() || this.isArr() || this.isMap() || this.isIterator() || this.isStream() || this.isEnumeration();
    }

    public boolean isMap() {
        return this.raw instanceof Map;
    }

    public boolean isStream() {
        return this.raw instanceof Stream;
    }

    public boolean isIterator() {
        return this.raw instanceof Iterator;
    }

    public boolean isEnumeration() {
        return this.raw instanceof Enumeration;
    }

    public boolean isIterable() {
        return this.raw instanceof Iterable;
    }

    public boolean isArr() {
        return !this.isNull() && this.raw.getClass().isArray();
    }

    public boolean isPrimitiveArr() {
        return this.isArr() && !(this.raw instanceof Object[]);
    }

    public boolean isMultiDimArr() {
        return this.isArr() && this.raw.getClass().getComponentType().isArray();
    }

    public EnhancedClass<T> type() {
        return this.isNull() ? EnhancedClass.ofNull() : EnhancedClass.of(this.raw.getClass());
    }

    public EnhancedClass<?> componentType() {
        if (this.isNull()) {
            return null;
        }
        Class<?> rawClass = this.raw.getClass();
        if (!this.isMultiVal()) {
            return EnhancedClass.of(rawClass);
        }
        if (rawClass.isArray()) {
            Class<?> componentClass = rawClass.getComponentType();
            while (componentClass.isArray()) {
                componentClass = componentClass.getComponentType();
            }
            return EnhancedClass.of(componentClass);
        }
        return EnhancedClass.of(Object.class);
    }

    public Stream<EnhancedMethod> methods() {
        return this.isNull() ? Stream.empty() : this.type().methods();
    }

    public Stream<EnhancedMethod> methodsNamed(String name) {
        return this.methods().filter(e -> e.name().equals(name));
    }

    public EnhancedMethod methodOf(String name, Class<?> argClasses) {
        return this.isNull() ? null : EnhancedMethod.of(ClassKit.methodOf(this.raw.getClass(), name, argClasses));
    }

    @Override
    public T unwrap() {
        return this.raw;
    }

    public String toString() {
        return String.valueOf(this.raw);
    }

    public int hashCode() {
        return Objects.hash(this.raw);
    }

    public boolean equals(Object o) {
        return Objects.equals(this.raw, o);
    }

    public static <T> EnhancedObj<T> of(T o) {
        return o == null ? null : new EnhancedObj<T>(o);
    }

    public static EnhancedObj<Boolean> of(boolean o) {
        return new EnhancedObj<Boolean>(o, true);
    }

    public static EnhancedObj<Byte> of(byte o) {
        return new EnhancedObj<Byte>(o, true);
    }

    public static EnhancedObj<Short> of(short o) {
        return new EnhancedObj<Short>(o, true);
    }

    public static EnhancedObj<Integer> of(int o) {
        return new EnhancedObj<Integer>(o, true);
    }

    public static EnhancedObj<Long> of(long o) {
        return new EnhancedObj<Long>(o, true);
    }

    public static EnhancedObj<Float> of(float o) {
        return new EnhancedObj<Float>(Float.valueOf(o), true);
    }

    public static EnhancedObj<Double> of(double o) {
        return new EnhancedObj<Double>(o, true);
    }

    public static EnhancedObj<Character> of(char o) {
        return new EnhancedObj<Character>(Character.valueOf(o), true);
    }
}

