/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang.java;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import java.util.stream.Collectors;

public class EnumKit<E extends Enum<E>> {
    private EnumKit() {
    }

    public static <E extends Enum<E>> E valueOf(Class<E> clazz, String name) {
        Enum[] es = (Enum[])clazz.getEnumConstants();
        return (E)((Enum)Arrays.stream(es).filter(e -> e.name().equalsIgnoreCase(name)).findFirst().orElse(null));
    }

    @SafeVarargs
    public static <E extends Enum<E>> EnumSet<E> toEnumSet(E ... es) {
        return EnumSet.copyOf(Arrays.asList(es));
    }

    public static <E extends Enum<E>> long enumSetToMasks(Collection<E> enums) {
        if (enums.isEmpty()) {
            return 0L;
        }
        EnumSet<E> enumSet = enums instanceof EnumSet ? (EnumSet<E>)enums : EnumSet.copyOf(enums);
        BitSet bitSet = new BitSet();
        enumSet.forEach(e -> bitSet.set(e.ordinal()));
        return bitSet.toLongArray()[0];
    }

    public static <E extends Enum<E>> EnumSet<E> masksToEnumSet(long masks, Class<E> enumClass) {
        Enum[] enums = (Enum[])enumClass.getEnumConstants();
        return BitSet.valueOf(new long[]{masks}).stream().mapToObj(i -> i < enums.length ? enums[i] : null).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(enumClass)));
    }
}

