/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang.java;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;
import me.magicall.support.TwoTuple;
import me.magicall.support.lang.java.BeanKit;
import me.magicall.support.lang.java.MethodKit;

public interface FieldValueAccessor<E> {
    public static final FieldValueAccessor<Map<String, Object>> MAP_VALUE_ACCESSOR = new FieldValueAccessor<Map<String, Object>>(){

        @Override
        public Object getValue(Map<String, Object> obj, String fieldName) {
            return obj.get(fieldName);
        }

        @Override
        public void setValue(Map<String, Object> obj, String fieldName, Object value) {
            obj.put(fieldName, value);
        }
    };
    public static final FieldValueAccessor<Object> BEAN_VALUE_ACCESSOR = new FieldValueAccessor<Object>(){
        private final Map<TwoTuple<Class<?>, String>, Method> getters = new WeakHashMap();
        private final Map<TwoTuple<Class<?>, String>, Method> setters = new WeakHashMap();

        @Override
        public Object getValue(Object obj, String fieldName) {
            Class<?> c = obj.getClass();
            TwoTuple key = new TwoTuple(c, fieldName);
            Method method = this.getters.computeIfAbsent(key, k -> BeanKit.getGetter(fieldName, c));
            return MethodKit.invoke(obj, method, new Object[0]);
        }

        @Override
        public void setValue(Object obj, String fieldName, Object value) {
            if (value == null) {
                return;
            }
            Class<?> c = obj.getClass();
            TwoTuple key = new TwoTuple(c, fieldName);
            Method method = this.setters.computeIfAbsent(key, k -> BeanKit.getSetterIgnoreNameCaseAndTypeAssigned(c, value.getClass()));
            MethodKit.invoke(obj, method, value);
        }
    };

    public Object getValue(E var1, String var2);

    public void setValue(E var1, String var2, Object var3);
}

