/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang.java;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import me.magicall.support.lang.java.NumKit;

public final class FloatKit
extends NumKit<Float, float[]>
implements Serializable {
    private static final long serialVersionUID = 3697543384462295628L;
    private static final List<Class<?>> SUPPORTED_CLASSES = Arrays.asList(Float.class, Float.TYPE);
    public static final FloatKit INSTANCE = new FloatKit();

    @Override
    public Stream<Class<?>> supportedClasses() {
        return SUPPORTED_CLASSES.stream();
    }

    @Override
    public Float parse(String source) {
        try {
            return Float.valueOf(Float.parseFloat(source.trim()));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public <T1, T2> Float emptyVal() {
        return Float.valueOf(0.0f);
    }

    @Override
    public String primitiveArrFlag() {
        return "F";
    }

    @Override
    public Float fromLong(long value) {
        return Float.valueOf(value);
    }

    private Object readResolve() {
        return INSTANCE;
    }
}

