/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang.java;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import me.magicall.support.lang.java.NotFractionKit;

public final class IntKit
extends NotFractionKit<Integer, int[]> {
    private static final long serialVersionUID = 191546508666204317L;
    private static final List<Class<?>> SUPPORTED_CLASSES = Arrays.asList(Integer.class, Integer.TYPE);
    public static final IntKit INSTANCE = new IntKit();

    @Override
    public Stream<Class<?>> supportedClasses() {
        return SUPPORTED_CLASSES.stream();
    }

    @Override
    public Integer parse(String source) {
        try {
            return Integer.parseInt(source, 10);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public String primitiveArrFlag() {
        return "I";
    }

    @Override
    public Integer fromLong(long value) {
        return (int)value;
    }

    private Object readResolve() {
        return INSTANCE;
    }
}

