/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang.java;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import me.magicall.support.coll.CollKit;
import me.magicall.support.exception.UnknownException;
import me.magicall.support.lang.java.ArrKit;
import me.magicall.support.lang.java.ClassKit;

public abstract class Kit<T>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = -8454331944139332595L;

    public String toString() {
        return this.supportedTypeNames().collect(Collectors.joining(", "));
    }

    public abstract Stream<Class<?>> supportedClasses();

    public Stream<String> supportedTypeNames() {
        List supportedClasses = this.supportedClasses().collect(Collectors.toList());
        Stream[] streams = new Stream[]{supportedClasses.stream().map(Class::getName), supportedClasses.stream().map(Class::getSimpleName)};
        return CollKit.concat(streams);
    }

    public boolean isSuitForInstance(Object obj) {
        Class<?> c = obj.getClass();
        while (c.isArray()) {
            c = ClassKit.componentType(c);
        }
        Class<?> clazz = c;
        return this.supportedClasses().anyMatch(e -> e.isAssignableFrom(clazz));
    }

    public boolean isSuitForTypeName(String className) {
        return this.supportedTypeNames().anyMatch(e -> e.equalsIgnoreCase(className));
    }

    public boolean isSuitFor(Class<?> clazz) {
        return this.supportedClasses().anyMatch(e -> e.isAssignableFrom(clazz));
    }

    public boolean equals(T o1, Object o2) {
        return Objects.equals(o1, o2);
    }

    public T fromString(String source) {
        if (source == null) {
            return null;
        }
        if (source.isBlank()) {
            return this.emptyVal();
        }
        return this.parse(source);
    }

    public abstract T parse(String var1);

    public abstract <T1, T2> T emptyVal();

    public boolean isEmpty(T source) {
        return this.emptyVal().equals(this.nullOrEmptyVal(source));
    }

    public <T1 extends T> T1 nullOrEmptyVal(T1 source) {
        return this.nullOrDefaultVal(source, this.emptyVal());
    }

    public <T1 extends T> T1 nullOrDefaultVal(T1 source, T1 defaultValue) {
        if (source == null) {
            return defaultValue;
        }
        return source;
    }

    @Override
    public int compare(T o1, T o2) {
        if (o1 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2);
        }
        return -1;
    }

    @SafeVarargs
    public final T max(T ... source) {
        return source == null ? null : Stream.of(source).max(this).orElse(null);
    }

    @SafeVarargs
    public final T min(T ... source) {
        return source == null ? null : Stream.of(source).min(this).orElse(null);
    }

    public boolean greater(T source, T target) {
        return this.compare(source, target) > 0;
    }

    public boolean greaterEquals(T source, T target) {
        return this.compare(source, target) >= 0;
    }

    public boolean less(T source, T target) {
        return this.greater(target, source);
    }

    public boolean lessEquals(T source, T target) {
        return this.greaterEquals(target, source);
    }

    public T[] arr(int size) {
        return size < 1 ? this.emptyArr() : (Object[])Array.newInstance(this.mainClass(), size);
    }

    public T[] emptyArr() {
        return (Object[])Array.newInstance(this.mainClass(), 0);
    }

    public T[] nCopy(int size, T value) {
        Object[] rt = this.arr(size);
        IntStream.range(0, size).forEach(i -> {
            rt[i] = value;
        });
        return rt;
    }

    public T[] emptyValArr(int size) {
        return this.nCopy(size, this.emptyVal());
    }

    public Class<? extends Object[]> arrClass(int dim) {
        return ArrKit.arrClass(this.mainClass(), dim);
    }

    protected Class<T> mainClass() {
        return this.supportedClasses().findFirst().orElseThrow(UnknownException::new);
    }
}

