/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang.java;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.magicall.support.coll.CollKit;
import me.magicall.support.coll.ListKit;
import me.magicall.support.coll.MapKit;
import me.magicall.support.coll.SetKit;
import me.magicall.support.lang.java.BoolKit;
import me.magicall.support.lang.java.ByteKit;
import me.magicall.support.lang.java.CharKit;
import me.magicall.support.lang.java.DateKit;
import me.magicall.support.lang.java.DoubleKit;
import me.magicall.support.lang.java.FloatKit;
import me.magicall.support.lang.java.IntKit;
import me.magicall.support.lang.java.Kit;
import me.magicall.support.lang.java.LongKit;
import me.magicall.support.lang.java.ObjKit;
import me.magicall.support.lang.java.PrimitiveKit;
import me.magicall.support.lang.java.ShortKit;
import me.magicall.support.lang.java.StrKit;

public class Kits {
    public static final IntKit INT = IntKit.INSTANCE;
    public static final LongKit LONG = LongKit.INSTANCE;
    public static final ByteKit BYTE = ByteKit.INSTANCE;
    public static final ShortKit SHORT = ShortKit.INSTANCE;
    public static final FloatKit FLOAT = FloatKit.INSTANCE;
    public static final DoubleKit DOUBLE = DoubleKit.INSTANCE;
    public static final CharKit CHAR = CharKit.INSTANCE;
    public static final BoolKit BOOL = BoolKit.INSTANCE;
    public static final StrKit STR = StrKit.INSTANCE;
    public static final ObjKit OBJ = ObjKit.INSTANCE;
    public static final DateKit DATE = DateKit.INSTANCE;
    public static final CollKit COLL = CollKit.INSTANCE;
    public static final SetKit SET = SetKit.INSTANCE;
    public static final ListKit LIST = ListKit.INSTANCE;
    public static final MapKit MAP = MapKit.INSTANCE;
    private static final Collection<Kit<?>> ALL = Collections.unmodifiableCollection(Arrays.asList(INT, STR, BOOL, DATE, OBJ, COLL, LIST, SET, MAP, FLOAT, LONG, DOUBLE, BYTE, SHORT, CHAR));
    private static final List<Kit<?>> SUIT_LIST = LIST.unmodifiable(Arrays.asList(INT, LONG, DOUBLE, FLOAT, CHAR, BYTE, SHORT, STR, BOOL, DATE, LIST, SET, MAP, COLL, OBJ));
    private static final Collection<PrimitiveKit<?, ?>> ALL_PRIMITIVE_CLASS_UTILS = Collections.unmodifiableCollection(Arrays.asList(INT, BOOL, FLOAT, LONG, DOUBLE, BYTE, SHORT, CHAR));
    private static final BiMap<Class<?>, Class<?>> PRIMITIVE_CLASS_REF;

    public static Kit<?> suitableUtil(Object obj) {
        List<Kit<?>> all = SUIT_LIST;
        return all.stream().filter(u -> u.isSuitForInstance(obj)).findFirst().orElse(OBJ);
    }

    public static Collection<Kit<?>> getAll() {
        return ALL;
    }

    public static <T> Kit<T> of(String name) {
        return Kits.getAll().stream().filter(u -> u.supportedTypeNames().anyMatch(s -> s.equalsIgnoreCase(name))).findFirst().orElse(null);
    }

    public static <T> Kit<T> of(Class<?> clazz) {
        return Kits.getAll().stream().filter(u -> u.supportedClasses().anyMatch(c -> c.isAssignableFrom(clazz))).findFirst().orElse(null);
    }

    public static Class<?> wrapClass(Class<?> primitiveClass) {
        return (Class)PRIMITIVE_CLASS_REF.get(primitiveClass);
    }

    public static Class<?> primitiveClass(Class<?> primitiveClass) {
        return (Class)PRIMITIVE_CLASS_REF.inverse().get(primitiveClass);
    }

    public static <T, A> PrimitiveKit<T, A> ofPrimitive(String name) {
        return Kits.getAllPrimitiveClassUtils().stream().filter(u -> u.supportedTypeNames().anyMatch(s -> s.equalsIgnoreCase(name))).findFirst().orElse(null);
    }

    public static <T, A> PrimitiveKit<T, A> getPrimitiveKit(Class<?> clazz) {
        Collection<PrimitiveKit<?, ?>> all = Kits.getAllPrimitiveClassUtils();
        return all.stream().filter(u -> u.isSuitFor(clazz)).findFirst().orElse(null);
    }

    public static Collection<PrimitiveKit<?, ?>> getAllPrimitiveClassUtils() {
        return ALL_PRIMITIVE_CLASS_UTILS;
    }

    public static boolean isPrimitiveOrWrapper(Class<?> clazz) {
        return PRIMITIVE_CLASS_REF.containsKey(clazz) || PRIMITIVE_CLASS_REF.containsValue(clazz);
    }

    public static Collection<Class<?>> allPrimitiveClasses() {
        return PRIMITIVE_CLASS_REF.keySet();
    }

    public static Collection<Class<?>> allWrapClasses() {
        return PRIMITIVE_CLASS_REF.values();
    }

    public static void main(String ... args) {
    }

    static {
        HashBiMap tmp = HashBiMap.create((int)8);
        tmp.put(Integer.TYPE, Integer.class);
        tmp.put(Boolean.TYPE, Boolean.class);
        tmp.put(Float.TYPE, Float.class);
        tmp.put(Long.TYPE, Long.class);
        tmp.put(Double.TYPE, Double.class);
        tmp.put(Byte.TYPE, Byte.class);
        tmp.put(Short.TYPE, Short.class);
        tmp.put(Character.TYPE, Character.class);
        PRIMITIVE_CLASS_REF = tmp;
    }
}

