/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang.java;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import me.magicall.support.lang.java.NotFractionKit;

public final class LongKit
extends NotFractionKit<Long, long[]> {
    private static final long serialVersionUID = -5401432022261827640L;
    public static final LongKit INSTANCE = new LongKit();
    private static final List<Class<?>> SUPPORTED_CLASSES = Arrays.asList(Long.class, Long.TYPE);

    @Override
    public Stream<Class<?>> supportedClasses() {
        return SUPPORTED_CLASSES.stream();
    }

    @Override
    public Stream<String> supportedTypeNames() {
        return Stream.concat(super.supportedTypeNames(), Stream.of("bigint"));
    }

    @Override
    public Long parse(String source) {
        try {
            return Long.parseLong(source);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    @Override
    public String primitiveArrFlag() {
        return "J";
    }

    @Override
    public Long fromLong(long value) {
        return value;
    }

    private Object readResolve() {
        return INSTANCE;
    }
}

