/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang.java;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import me.magicall.support.exception.UnknownException;
import me.magicall.support.exception.WrongArgException;
import me.magicall.support.exception.WrongStatusException;
import me.magicall.support.lang.java.ArrKit;
import me.magicall.support.lang.java.ReflectKit;
import me.magicall.support.lang.java.StrKit;

public interface MethodKit {
    public static final Predicate<Method> IS_EQUALS = MethodKit::isTheEquals;
    public static final Predicate<Method> IS_HASH_CODE = MethodKit::isHashCode;
    public static final Predicate<Method> IS_TO_STRING = MethodKit::isToString;
    public static final Predicate<Method> IS_GET_CLASS = MethodKit::isGetClass;
    public static final Predicate<Method> IS_DEFAULT = Method::isDefault;
    public static final Predicate<Method> IS_DEFINED_IN_OBJECT_CLASS = ReflectKit.IS_DEFINED_IN_OBJECT_CLASS;
    public static final Predicate<Method> IS_NOT_DEFINED_IN_OBJECT_CLASS = ReflectKit.IS_NOT_DEFINED_IN_OBJECT_CLASS;
    public static final Predicate<Method> ALL = ReflectKit.ALL;
    public static final Predicate<Method> NONE = ReflectKit.NONE;
    public static final Predicate<Method> IS_PUBLIC = ReflectKit.IS_PUBLIC;
    public static final Predicate<Method> IS_PRIVATE = ReflectKit.IS_PRIVATE;
    public static final Predicate<Method> IS_PROTECTED = ReflectKit.IS_PROTECTED;
    public static final Predicate<Method> IS_DEFAULT_ACCESS = ReflectKit.IS_DEFAULT_ACCESS;
    public static final Predicate<Method> IS_STATIC = ReflectKit.IS_STATIC;
    public static final Class<?>[] JUST_ONE_OBJ_CLASS = new Class[]{Object.class};

    public static String toSignature(Method method) {
        Object[] parameterTypes = method.getParameterTypes();
        return StrKit.format("{0}.{1}({2})", method.getDeclaringClass().getName(), method.getName(), parameterTypes.length == 0 ? "" : Arrays.toString(parameterTypes));
    }

    public static Object invoke(Object obj, Method method, Object ... args) {
        if (!method.getDeclaringClass().isInstance(obj)) {
            throw new WrongArgException("caller", obj);
        }
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(obj, args);
        }
        catch (IllegalArgumentException e) {
            throw new WrongArgException("args", (Object)args, e);
        }
        catch (IllegalAccessException e) {
            throw new UnknownException(e);
        }
        catch (InvocationTargetException e) {
            throw new WrongStatusException("method owner", obj, e);
        }
    }

    @Deprecated
    public static Method findMethodIgnoreCaseAndArgsTypesAssigned(Method[] methods, String methodName, Class<?> ... argsClasses) {
        return MethodKit.findMethodIgnoreCaseAndArgsTypesAssigned(Arrays.asList(methods), methodName, argsClasses);
    }

    @Deprecated
    public static Method findMethodIgnoreCaseAndArgsTypesAssigned(Collection<Method> methods, String methodName, Class<?> ... argsClasses) {
        Method method = null;
        for (Method m : methods) {
            String name = m.getName();
            Object[] argTypes = m.getParameterTypes();
            if (argsClasses.length != argTypes.length || !name.equalsIgnoreCase(methodName)) continue;
            if (Arrays.equals(argTypes, argsClasses)) {
                return m;
            }
            int i = 0;
            for (Object argType : argTypes) {
                if (!((Class)argType).isAssignableFrom(argsClasses[i])) break;
                ++i;
            }
            if (i != argsClasses.length) continue;
            method = m;
        }
        return method;
    }

    public static boolean isStatic(Method method) {
        return ReflectKit.isStatic(method);
    }

    public static boolean hasReturn(Method method) {
        return !MethodKit.hasNoReturn(method);
    }

    public static boolean hasNoReturn(Method method) {
        return method.getReturnType() == Void.TYPE;
    }

    public static boolean isTheEquals(Method method) {
        return MethodKit.nameMatch(method, "equals") && Arrays.equals(JUST_ONE_OBJ_CLASS, method.getParameterTypes());
    }

    public static boolean isHashCode(Method method) {
        return MethodKit.nameMatchAndNoArg(method, "hashCode");
    }

    public static boolean isToString(Method method) {
        return MethodKit.nameMatchAndNoArg(method, "toString");
    }

    public static boolean isGetClass(Method method) {
        return MethodKit.nameMatchAndNoArg(method, "getClass");
    }

    public static boolean hasArgs(Method method) {
        return !MethodKit.hasNoArg(method);
    }

    public static boolean hasNoArg(Method method) {
        return ArrKit.isEmpty(method.getParameterTypes());
    }

    private static boolean nameMatchAndNoArg(Method method, String name) {
        return MethodKit.nameMatch(method, name) && MethodKit.hasNoArg(method);
    }

    private static boolean nameMatch(Method method, String name) {
        return name.equals(method.getName());
    }
}

