/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang.java;

import java.util.Arrays;
import java.util.Objects;

public final class MethodSignature {
    private static final Class<?>[] EMPTY_CLASS_ARR = new Class[0];
    public static final MethodSignature TO_STRING = new MethodSignature(Object.class, "toString", new Class[0]);
    public static final MethodSignature EQUALS = new MethodSignature(Object.class, "equals", Object.class);
    public static final MethodSignature HASH_CODE = new MethodSignature(Object.class, "hashCode", new Class[0]);
    private final Class<?> ownerClass;
    private final String name;
    private final Class<?>[] argClasses;

    public MethodSignature(Class<?> ownerClass, String name, Class<?> ... argClasses) {
        this.ownerClass = ownerClass;
        this.name = name;
        this.argClasses = argClasses == null ? EMPTY_CLASS_ARR : argClasses;
    }

    public Class<?> getOwnerClass() {
        return this.ownerClass;
    }

    public String getName() {
        return this.name;
    }

    public Class<?>[] getArgClasses() {
        return this.argClasses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodSignature that = (MethodSignature)o;
        return Objects.equals(this.ownerClass, that.ownerClass) && Objects.equals(this.name, that.name) && Arrays.equals(this.argClasses, that.argClasses);
    }

    public int hashCode() {
        int result = Objects.hash(this.ownerClass, this.name);
        result = 31 * result + Arrays.hashCode(this.argClasses);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.ownerClass.getName()).append('.').append(this.name).append('(');
        if (this.argClasses.length > 0) {
            int i = 0;
            for (Class<?> argClass : this.argClasses) {
                sb.append(argClass.getName()).append(" arg").append(i).append(',');
                ++i;
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.append(')').toString();
    }
}

