/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang.java;

import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import me.magicall.support.lang.java.NumKit;

abstract class NotFractionKit<N extends Number, A>
extends NumKit<N, A> {
    private static final long serialVersionUID = -4160614628198930694L;

    NotFractionKit() {
    }

    @Override
    public <T1, T2> N emptyVal() {
        return this.fromLong(0L);
    }

    private static boolean maskTest0(long bigLongValue, long smallLongValue) {
        return (bigLongValue & smallLongValue) == smallLongValue;
    }

    public boolean maskTest(N big, N small) {
        return NotFractionKit.maskTest0(((Number)big).longValue(), ((Number)small).longValue());
    }

    @SafeVarargs
    public final boolean maskTest(N big, N ... smalls) {
        return smalls == null || this.maskTest0(((Number)big).longValue(), Arrays.stream(smalls));
    }

    public boolean maskTest(N big, A smalls) {
        return smalls == null || this.maskTest0(((Number)big).longValue(), IntStream.range(0, this.arrLen(smalls)).mapToObj(i -> (Number)this.valAt(smalls, i)));
    }

    private boolean maskTest0(long bigLongValue, Stream<N> stream) {
        return stream.mapToLong(rec$ -> ((Number)rec$).longValue()).allMatch(smallLongValue -> NotFractionKit.maskTest0(bigLongValue, smallLongValue));
    }

    @SafeVarargs
    public final N and(N source, N ... masks) {
        if (masks == null) {
            return source;
        }
        N rt = source;
        for (N n : masks) {
            rt = this.and(rt, n);
        }
        return rt;
    }

    public N and(N source, A masks) {
        if (masks == null) {
            return source;
        }
        int len = this.arrLen(masks);
        Object rt = source;
        for (int i = 0; i < len; ++i) {
            rt = this.and((N)rt, (N)((Number)this.valAt(masks, i)));
        }
        return rt;
    }

    @SafeVarargs
    public final N or(N source, N ... ns) {
        if (ns == null) {
            return source;
        }
        N rt = source;
        for (N n : ns) {
            rt = this.or(rt, n);
        }
        return rt;
    }

    public N or(N source, A ns) {
        if (ns == null) {
            return source;
        }
        int len = this.arrLen(ns);
        Object rt = source;
        for (int i = 0; i < len; ++i) {
            rt = this.or((N)rt, (N)((Number)this.valAt(ns, i)));
        }
        return rt;
    }

    public N and(N source, N mask) {
        return this.fromLong(((Number)source).longValue() & ((Number)mask).longValue());
    }

    public N or(N source, N n) {
        return this.fromLong(((Number)source).longValue() | ((Number)n).longValue());
    }

    public N not(N source) {
        return this.fromLong(((Number)source).longValue() ^ 0xFFFFFFFFFFFFFFFFL);
    }
}

