/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang.java;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import me.magicall.support.coll.CollKit;
import me.magicall.support.lang.java.ArrKit;
import me.magicall.support.lang.java.Kit;
import me.magicall.support.lang.java.NumKit;
import me.magicall.support.lang.java.StrKit;
import org.apache.commons.lang3.reflect.FieldUtils;

public class ObjKit
extends Kit<Object>
implements Serializable {
    private static final long serialVersionUID = 2807499119655747354L;
    private static final List<Class<?>> SUPPORTED_CLASSES = Collections.singletonList(Object.class);
    public static final ObjKit INSTANCE = new ObjKit();
    private static final Object EMPTY_VALUE = new Object();

    @Override
    public Stream<Class<?>> supportedClasses() {
        return SUPPORTED_CLASSES.stream();
    }

    @Override
    public Stream<String> supportedTypeNames() {
        return Stream.concat(super.supportedTypeNames(), Stream.of("obj"));
    }

    @Override
    public Object parse(String source) {
        return source;
    }

    @Override
    public <T1, T2> Object emptyVal() {
        return EMPTY_VALUE;
    }

    public static <T> T cast(Object obj) {
        return (T)obj;
    }

    public static Field field(Class<?> clazz, String fieldName) {
        return FieldUtils.getDeclaredField(clazz, (String)fieldName, (boolean)true);
    }

    public static Object fieldVal(Object o, String fieldName) {
        if (o instanceof Map) {
            return ((Map)o).get(fieldName);
        }
        try {
            return FieldUtils.readField((Object)o, (String)fieldName, (boolean)true);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean letFieldBe(Object target, Field field, Object value) {
        try {
            FieldUtils.writeField((Field)field, (Object)target, (Object)value);
            return true;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Stream<?> toList(Object o) {
        if (o == null) {
            return Stream.empty();
        }
        if (o instanceof Iterable) {
            return StreamSupport.stream(((Iterable)o).spliterator(), false);
        }
        if (o instanceof Iterator) {
            return CollKit.stream((Iterator)o);
        }
        if (ObjKit.isArr(o)) {
            return ArrKit.asList(o).stream();
        }
        if (o instanceof Stream) {
            return (Stream)o;
        }
        if (o instanceof Spliterator) {
            return StreamSupport.stream((Spliterator)o, false);
        }
        if (o instanceof Enumeration) {
            return Collections.list((Enumeration)o).stream();
        }
        return Stream.of(o);
    }

    public static boolean isMultiValue(Object o) {
        return o instanceof Iterable || o instanceof Iterator || o instanceof Stream || ObjKit.isArr(o) || o instanceof Spliterator || o instanceof Enumeration;
    }

    public static boolean deepEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        if (o1.equals(o2)) {
            return true;
        }
        return ObjKit.deepEquals(o1, o2, null);
    }

    static boolean deepEquals(Object o1, Object o2, Set<Object> escape) {
        if (escape != null && (escape.contains(o1) || escape.contains(o2))) {
            return false;
        }
        Class<?> c1 = o1.getClass();
        Class<?> c2 = o2.getClass();
        if (!c1.isArray()) {
            if (!c2.isArray()) {
                if (o1.equals(o2)) {
                    return true;
                }
                if (o1 instanceof Number && o2 instanceof Number) {
                    return NumKit.deepEquals((Number)o1, (Number)o2);
                }
            }
            return false;
        }
        if (!c2.isArray()) {
            return false;
        }
        Class<?> cc1 = c1.getComponentType();
        Class<?> cc2 = c2.getComponentType();
        if (cc1.isPrimitive()) {
            if (cc2.isPrimitive()) {
                return ArrKit.primitivesArrEquals(o1, o2);
            }
            return false;
        }
        if (cc2.isPrimitive()) {
            return false;
        }
        Set<Object> escapeToUse = escape == null ? Sets.newHashSet() : escape;
        escapeToUse.add(o1);
        escapeToUse.add(o2);
        return ArrKit.deepEquals((Object[])o1, (Object[])o2, escapeToUse);
    }

    public static boolean isArr(Object obj) {
        return obj != null && obj.getClass().isArray();
    }

    public static <T> T[] toObjectArray(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof Object[]) {
            return (Object[])source;
        }
        Class<?> c = source.getClass();
        if (!c.isArray()) {
            return null;
        }
        int length = Array.getLength(source);
        Class<?> cc = c.getComponentType();
        if (length == 0) {
            return (Object[])Array.newInstance(cc, 0);
        }
        Object[] newArray = (Object[])Array.newInstance(cc, length);
        IntStream.range(0, length).forEach(i -> {
            newArray[i] = Array.get(source, i);
        });
        return newArray;
    }

    public static String deepToString(Object obj) {
        if (obj == null) {
            return StrKit.NULL;
        }
        return ObjKit.deepToString(obj, new StringBuilder(), new HashSet<Object>()).toString();
    }

    static StringBuilder deepToString(Object obj, StringBuilder sb, Set<Object> escape) {
        if (obj == null) {
            return sb.append(StrKit.NULL);
        }
        if (escape.contains(obj)) {
            return sb.append("...");
        }
        Class<?> c = obj.getClass();
        if (c.isArray()) {
            escape.add(obj);
            sb.append('[');
            int len = Array.getLength(obj);
            IntStream.range(0, len).forEach(i -> {
                if (i != 0) {
                    sb.append(',');
                }
                ObjKit.deepToString(Array.get(obj, i), sb, escape);
            });
            sb.append(']');
        } else if (obj instanceof Iterable) {
            escape.add(obj);
            Iterable iterable = (Iterable)obj;
            for (Object o : iterable) {
                ObjKit.deepToString(o, sb, escape);
            }
        } else if (obj instanceof Map) {
            escape.add(obj);
            Map m = (Map)obj;
            sb.append('{');
            if (!m.isEmpty()) {
                m.forEach((key, value) -> {
                    ObjKit.deepToString(key, sb, escape).append(" = ");
                    ObjKit.deepToString(value, sb, escape).append(',');
                });
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append('}');
        } else {
            sb.append(obj);
        }
        return sb;
    }

    private Object readResolve() {
        return INSTANCE;
    }
}

