/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang.java;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import me.magicall.support.computer.Encode;
import me.magicall.support.exception.UnknownException;
import me.magicall.support.lang.java.ClassKit;

public class PackageKit {
    public static boolean isAnnotationPresentInHierarchy(Package pack, Class<? extends Annotation> annotationClass) {
        return Stream.iterate(pack, Objects::nonNull, PackageKit::parent).anyMatch(p -> p.isAnnotationPresent(annotationClass));
    }

    public static Package parent(Package pack) {
        String name = pack.getName();
        int index = name.lastIndexOf(46);
        if (index < 0) {
            return null;
        }
        return pack.getClass().getClassLoader().getDefinedPackage(name.substring(0, index));
    }

    public static Package[] parents(Package pack) {
        return (Package[])Stream.iterate(PackageKit.parent(pack), Objects::nonNull, PackageKit::parent).toArray(Package[]::new);
    }

    public static Package[] parents(Class<?> clazz) {
        return (Package[])Stream.iterate(clazz.getPackage(), Objects::nonNull, PackageKit::parent).toArray(Package[]::new);
    }

    public static Package packageOf(Class<?> c) {
        return c == null ? null : c.getPackage();
    }

    public static Set<Class<?>> classesOf(Package pack) {
        ArrayList<URL> dirs;
        String packageName = pack.getName();
        String packageDirName = packageName.replace('.', '/');
        try {
            dirs = Collections.list(Thread.currentThread().getContextClassLoader().getResources(packageDirName));
        }
        catch (IOException e) {
            throw new UnknownException(e);
        }
        LinkedHashSet rt = new LinkedHashSet();
        for (URL url : dirs) {
            JarURLConnection jarURLConnection;
            String protocol = url.getProtocol();
            if ("file".equals(protocol)) {
                String filePath;
                try {
                    filePath = URLDecoder.decode(url.getFile(), Encode.UTF8.getName());
                }
                catch (UnsupportedEncodingException e) {
                    throw new UnknownException(e);
                }
                PackageKit.findAndAddClassesInPackageByFile(packageName, filePath, true, rt);
                continue;
            }
            if (!"jar".equals(protocol)) continue;
            try {
                jarURLConnection = (JarURLConnection)url.openConnection();
            }
            catch (IOException e) {
                throw new UnknownException(e);
            }
            try {
                JarFile jar = jarURLConnection.getJarFile();
                try {
                    ArrayList<JarEntry> entries = Collections.list(jar.entries());
                    for (JarEntry entry : entries) {
                        String name = entry.getName();
                        if (name.charAt(0) == '/') {
                            name = name.substring(1);
                        }
                        if (!name.startsWith(packageDirName)) continue;
                        if (name.endsWith(".class") && !entry.isDirectory()) {
                            String className = name.substring(packageName.length() + 1, name.length() - ClassKit.FILE_SUFFIX_LEN);
                            rt.add(ClassKit.classCalled(packageName + "." + className));
                            continue;
                        }
                        int idx = name.lastIndexOf(47);
                        if (idx == -1) continue;
                        packageName = name.substring(0, idx).replace('/', '.');
                    }
                }
                finally {
                    if (jar == null) continue;
                    jar.close();
                }
            }
            catch (IOException e) {
                throw new UnknownException(e);
            }
        }
        return rt;
    }

    private static void findAndAddClassesInPackageByFile(String packageName, String packagePath, boolean recursive, Set<Class<?>> toAddTo) {
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] dirFiles = dir.listFiles(file -> recursive && file.isDirectory() || file.getName().endsWith(".class"));
        if (dirFiles != null) {
            Arrays.stream(dirFiles).forEach(file -> {
                if (file.isDirectory()) {
                    PackageKit.findAndAddClassesInPackageByFile(packageName + "." + file.getName(), file.getAbsolutePath(), recursive, toAddTo);
                } else {
                    String className = file.getName().substring(0, file.getName().length() - ClassKit.FILE_SUFFIX_LEN);
                    toAddTo.add(ClassKit.classCalled(packageName + "." + className));
                }
            });
        }
    }
}

