/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang.java;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import me.magicall.support.exception.WrongArgException;
import me.magicall.support.lang.java.ClassKit;
import me.magicall.support.lang.java.Kit;

public abstract class PrimitiveKit<P, A>
extends Kit<P>
implements Serializable {
    private static final long serialVersionUID = -4266565949179920712L;

    protected Class<?> primitiveClass() {
        return (Class)this.supportedClasses().collect(Collectors.toList()).get(1);
    }

    public abstract String primitiveArrFlag();

    public Class<?> primitiveArrClass(int nDim) {
        return ClassKit.arrClass(this.primitiveArrFlag(), nDim);
    }

    public Class<A> primitiveArrClass() {
        return this.primitiveArrClass(1);
    }

    public A nPrimitive(int size, P val) {
        if (size < 0) {
            throw new WrongArgException("size", (Object)size, ">=0");
        }
        A rt = this.newPrimitiveArr(size);
        IntStream.iterate(0, i -> i < size - 1, i -> i + 1).forEach(i -> this.setValAt(rt, i, val));
        return rt;
    }

    public A nPrimitiveEmptyVals(int size) {
        return this.nPrimitive(size, this.emptyVal());
    }

    public A emptyPrimitiveArr() {
        return this.nPrimitiveEmptyVals(0);
    }

    public int arrLen(A arr) {
        return arr == null ? 0 : this.arrLen0(arr);
    }

    public boolean isEmptyArr(A arr) {
        return this.arrLen(arr) == 0;
    }

    public Stream<P> toStream(A arr) {
        return Arrays.stream(this.wrap(arr));
    }

    public Iterator<P> iterate(A arr) {
        return this.toStream(arr).iterator();
    }

    public P valAt(A arr, int index) {
        return (P)Array.get(arr, index);
    }

    public void setValAt(A arr, int index, P val) {
        Array.set(arr, index, val);
    }

    public int frequency(P target, A arr) {
        return (int)this.toStream(arr).filter(Predicate.isEqual(target)).count();
    }

    public P[] wrap(A arr) {
        if (arr == null) {
            return this.emptyArr();
        }
        int len = this.arrLen0(arr);
        Object[] rt = this.arr(len);
        IntStream.range(0, len).forEach(i -> Array.set(rt, i, this.valAt(arr, i)));
        return rt;
    }

    @SafeVarargs
    public final A unwrap(P ... arr) {
        if (arr == null) {
            return this.emptyPrimitiveArr();
        }
        int len = arr.length;
        if (len == 0) {
            return this.emptyPrimitiveArr();
        }
        A rt = this.newPrimitiveArr(len);
        IntStream.range(0, len).forEach(i -> this.setValAt(rt, i, arr[i]));
        return rt;
    }

    public boolean arrEquals(A arr, Object other) {
        if (Objects.equals(arr, other)) {
            return true;
        }
        if (arr == null || other == null) {
            return false;
        }
        Class<?> c = other.getClass();
        if (!c.isArray()) {
            return false;
        }
        if (!this.isSuitFor(c.getComponentType())) {
            return false;
        }
        int len = this.arrLen(arr);
        if (Array.getLength(other) != len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            P arrayElement = this.valAt(arr, i);
            Object obj = Array.get(other, i);
            if (arrayElement == null || obj == null) {
                return false;
            }
            if (arrayElement.equals(obj)) continue;
            return false;
        }
        return true;
    }

    protected A newPrimitiveArr(int size) {
        return (A)Array.newInstance(this.primitiveClass(), size);
    }

    protected int arrLen0(A arr) {
        return Array.getLength(arr);
    }
}

