/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang.java;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import me.magicall.support.lang.java.NotFractionKit;

public final class ShortKit
extends NotFractionKit<Short, short[]> {
    private static final long serialVersionUID = -6638443404131445197L;
    public static final ShortKit INSTANCE = new ShortKit();
    private static final List<Class<?>> SUPPORTED_CLASSES = Arrays.asList(Short.class, Short.TYPE);

    @Override
    public Stream<Class<?>> supportedClasses() {
        return SUPPORTED_CLASSES.stream();
    }

    @Override
    public Short parse(String source) {
        try {
            return Short.parseShort(source);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public String primitiveArrFlag() {
        return "S";
    }

    @Override
    public Short fromLong(long value) {
        return (short)value;
    }

    private Object readResolve() {
        return INSTANCE;
    }
}

