/*
 * Decompiled with CFR 0.152.
 */
package me.magicall.support.lang.java;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import me.magicall.support.coll.ElementTransformer;
import me.magicall.support.lang.java.CharKit;
import me.magicall.support.lang.java.Kit;
import me.magicall.support.lang.java.Kits;

public class StrKit
extends Kit<String>
implements Serializable {
    public static final String[] EMPTY_STR_ARR = new String[0];
    public static final String NULL = String.valueOf(null);
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String[] SHORT_NAMES = new String[]{"str", "varchar"};
    public static final StrKit INSTANCE = new StrKit();
    private static final long serialVersionUID = -6560796645889471562L;
    private static final List<Class<?>> SUPPORTED_CLASSES = Arrays.asList(String.class);

    @Override
    public Stream<String> supportedTypeNames() {
        return Stream.concat(super.supportedTypeNames(), Stream.of(SHORT_NAMES));
    }

    @Override
    public String parse(String source) {
        return source;
    }

    @Override
    public <T1, T2> String emptyVal() {
        return "";
    }

    @Override
    public boolean isEmpty(String source) {
        return source == null || source.isBlank();
    }

    @Override
    public Stream<Class<?>> supportedClasses() {
        return SUPPORTED_CLASSES.stream();
    }

    @Override
    public boolean equals(String o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o2 instanceof CharSequence && o1.equalsIgnoreCase(((CharSequence)o2).toString());
    }

    public static String newLine() {
        return INSTANCE.nullOrDefaultVal(NEW_LINE, "\r\n");
    }

    public static char lastChar(String s) {
        return s.charAt(s.length() - 1);
    }

    public static String toUnicode(String source) {
        String s = INSTANCE.nullOrEmptyVal(source);
        StringBuilder sb = new StringBuilder(Kits.STR.emptyVal());
        int size = s.length();
        IntStream.range(0, size).map(s::codePointAt).forEach(c -> {
            if (c < 16) {
                sb.append("\\u000").append(Integer.toHexString(c));
            } else if (c < 256) {
                sb.append("\\u00").append(Integer.toHexString(c));
            } else if (c < 4096) {
                sb.append("\\u0").append(Integer.toHexString(c));
            } else {
                sb.append("\\u").append(Integer.toHexString(c));
            }
        });
        return sb.toString();
    }

    public static String toFullWidth(String input) {
        char[] c = input.toCharArray();
        IntStream.range(0, c.length).forEach(i -> {
            c[i] = CharKit.toFullWidth(c[i]);
        });
        return new String(c);
    }

    public static String toHalfWidth(String input) {
        char[] c = input.toCharArray();
        IntStream.range(0, c.length).forEach(i -> {
            c[i] = CharKit.toHalfWidth(c[i]);
        });
        return new String(c);
    }

    public static boolean startsWithIgnoreCase(String source, String target, boolean escapeStartingBlank) {
        String s2;
        String s1;
        if (escapeStartingBlank) {
            s1 = source.stripLeading();
            s2 = target.stripLeading();
        } else {
            s1 = source;
            s2 = target;
        }
        return s1.toLowerCase().startsWith(s2.toLowerCase());
    }

    public static boolean endsWithIgnoreCase(String source, String target, boolean escapeEndingBlank) {
        String s2;
        String s1;
        if (escapeEndingBlank) {
            s1 = source.stripTrailing();
            s2 = target.stripTrailing();
        } else {
            s1 = source;
            s2 = target;
        }
        return s1.toLowerCase().endsWith(s2.toLowerCase());
    }

    public static <E> StringBuilder join(StringBuilder sb, Iterable<E> iterable, String separator, ElementTransformer<? super E, String> tf) {
        Spliterator<E> spliterator = iterable.spliterator();
        spliterator.tryAdvance(obj -> sb.append((String)tf.transform(0, (Object)obj)));
        AtomicInteger i = new AtomicInteger(1);
        spliterator.forEachRemaining(e -> sb.append(separator).append((String)tf.transform(i.getAndIncrement(), (Object)e)));
        return sb;
    }

    public static String middle(String source, String before, boolean includeBefore, String after, boolean includeAfter) {
        int beforeIndex = source.indexOf(before);
        int startIndex = beforeIndex == -1 ? 0 : (!includeBefore ? beforeIndex + before.length() : beforeIndex);
        int afterIndex = source.indexOf(after, beforeIndex + before.length());
        int endIndex = afterIndex == -1 ? source.length() : (includeAfter ? afterIndex + after.length() : afterIndex);
        return source.substring(startIndex, endIndex);
    }

    public static String subStringBefore(String source, String seq, boolean lastSeq) {
        int index;
        int n = index = lastSeq ? source.lastIndexOf(seq) : source.indexOf(seq);
        if (index == -1) {
            return source;
        }
        return source.substring(0, index);
    }

    public static String subStringAfter(String source, String seq) {
        return source.substring(StrKit.indexAfter(source, seq));
    }

    public static String subStringAfterLastSeq(String source, String seq) {
        int lastIndexOf = source.lastIndexOf(seq);
        return lastIndexOf == -1 ? source : source.substring(lastIndexOf + seq.length());
    }

    public static int indexAfter(String source, String seq) {
        return StrKit.indexAfter(source, seq, 0);
    }

    public static int indexAfter(String source, String seq, int fromIndex) {
        int index = source.indexOf(seq, fromIndex);
        return index == -1 ? fromIndex : index + seq.length();
    }

    public static boolean containsIgnoreCase(String longOne, String shortOne) {
        return StrKit.indexOfIgnoreCase(longOne, shortOne) != -1;
    }

    public static int indexOfIgnoreCase(String longOne, String shortOne) {
        return longOne.toLowerCase().indexOf(shortOne.toLowerCase());
    }

    public static String format(String source, Object ... args) {
        return MessageFormat.format(source, args);
    }

    private Object readResolve() {
        return INSTANCE;
    }
}

